/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.sendreport.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.sendreport.connections.DBConnection;
import mx.com.videoturismo.sendreport.connections.PoolConnection;
import mx.com.videoturismo.sendreport.daos.CategoriaServicioDAO;
import mx.com.videoturismo.sendreport.daos.EstadoServicioDAO;
import mx.com.videoturismo.sendreport.daos.IServicioDAO;
import mx.com.videoturismo.sendreport.models.CategoriaServicio;
import mx.com.videoturismo.sendreport.models.EstadoServicio;
import mx.com.videoturismo.sendreport.models.Servicio;

public class ServicioDAO
implements IServicioDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Servicio> listAll() {
        ArrayList<Servicio> listaServicios = new ArrayList<Servicio>();
        CategoriaServicioDAO categoriaServicioDAO = new CategoriaServicioDAO();
        EstadoServicioDAO estadoServicioDAO = new EstadoServicioDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM servicios ORDER BY id_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idServicio = this.rs.getInt("id_servicio");
                int idCategoriaServicio = this.rs.getInt("id_categoria_servicio");
                String nombreServicio = this.rs.getString("nombre_servicio");
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                this.poolConnection.checkIn(this.cnn);
                CategoriaServicio categoriaServicio = categoriaServicioDAO.list(new CategoriaServicio(idCategoriaServicio));
                EstadoServicio estadoServicio = estadoServicioDAO.list(new EstadoServicio(idEstadoServicio));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Servicio servicio1 = new Servicio(idServicio, categoriaServicio, nombreServicio, estadoServicio);
                listaServicios.add(servicio1);
            }
            System.out.println("Se listaron correctamente todos los Servicio");
            return listaServicios;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaServicios;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Servicio> listAllReportedServices() {
        ArrayList<Servicio> listaServicios = new ArrayList<Servicio>();
        CategoriaServicioDAO categoriaServicioDAO = new CategoriaServicioDAO();
        EstadoServicioDAO estadoServicioDAO = new EstadoServicioDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM servicios WHERE id_estado_servicio = 2 ORDER BY id_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idServicio = this.rs.getInt("id_servicio");
                int idCategoriaServicio = this.rs.getInt("id_categoria_servicio");
                String nombreServicio = this.rs.getString("nombre_servicio");
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                this.poolConnection.checkIn(this.cnn);
                CategoriaServicio categoriaServicio = categoriaServicioDAO.list(new CategoriaServicio(idCategoriaServicio));
                EstadoServicio estadoServicio = estadoServicioDAO.list(new EstadoServicio(idEstadoServicio));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Servicio servicio1 = new Servicio(idServicio, categoriaServicio, nombreServicio, estadoServicio);
                listaServicios.add(servicio1);
            }
            System.out.println("Se listaron correctamente todos los Servicio reportados");
            return listaServicios;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaServicios;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Servicio> listAllByCategory(CategoriaServicio categoriaServicio) {
        ArrayList<Servicio> listaServicios = new ArrayList<Servicio>();
        CategoriaServicioDAO categoriaServicioDAO = new CategoriaServicioDAO();
        EstadoServicioDAO estadoServicioDAO = new EstadoServicioDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM servicios WHERE id_categoria_servicio = ? ORDER BY id_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, categoriaServicio.getIdCategoriaServicio());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idServicio = this.rs.getInt("id_servicio");
                String nombreServicio = this.rs.getString("nombre_servicio");
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                this.poolConnection.checkIn(this.cnn);
                categoriaServicio = categoriaServicioDAO.list(categoriaServicio);
                EstadoServicio estadoServicio = estadoServicioDAO.list(new EstadoServicio(idEstadoServicio));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Servicio servicio1 = new Servicio(idServicio, categoriaServicio, nombreServicio, estadoServicio);
                listaServicios.add(servicio1);
            }
            System.out.println("Se listaron correctamente todos los Servicio");
            return listaServicios;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaServicios;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Servicio list(Servicio servicio) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        CategoriaServicioDAO categoriaServicioDAO = new CategoriaServicioDAO();
        EstadoServicioDAO estadoServicioDAO = new EstadoServicioDAO();
        String sql = "SELECT * FROM servicios WHERE id_servicio = ? ORDER BY id_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, servicio.getIdServicio());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idServicio = this.rs.getInt("id_servicio");
                int idCategoriaServicio = this.rs.getInt("id_categoria_servicio");
                String nombreServicio = this.rs.getString("nombre_servicio");
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                this.poolConnection.checkIn(this.cnn);
                CategoriaServicio categoriaServicio = categoriaServicioDAO.list(new CategoriaServicio(idCategoriaServicio));
                EstadoServicio estadoServicio = estadoServicioDAO.list(new EstadoServicio(idEstadoServicio));
                this.cnn = (Connection)this.poolConnection.checkOut();
                servicio.setCategoriaServicio(categoriaServicio);
                servicio.setNombreServicio(nombreServicio);
                servicio.setEstadoServicio(estadoServicio);
            }
            System.out.println("Se list\u00f3 correctamente el Servicio");
            return servicio;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return servicio;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCategoryReported(CategoriaServicio categoriaServicio) {
        boolean reported = false;
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT id_estado_servicio FROM servicios WHERE id_categoria_servicio = ? ORDER BY id_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, categoriaServicio.getIdCategoriaServicio());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                if (idEstadoServicio != 2) continue;
                reported = true;
            }
            return reported;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return reported;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSomeServiceReported() {
        boolean reported = false;
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT id_estado_servicio FROM servicios ORDER BY id_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                if (idEstadoServicio != 2) continue;
                reported = true;
            }
            return reported;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return reported;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isServiceReported(Servicio servicio) {
        boolean reported = false;
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT id_estado_servicio FROM servicios WHERE id_servicio = ? ORDER BY id_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, servicio.getIdServicio());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                if (idEstadoServicio != 2) continue;
                reported = true;
            }
            return reported;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return reported;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reportService(Servicio servicio) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        CategoriaServicioDAO categoriaServicioDAO = new CategoriaServicioDAO();
        EstadoServicioDAO estadoServicioDAO = new EstadoServicioDAO();
        String sql = "UPDATE servicios SET id_estado_servicio = ? WHERE id_servicio = ?";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, 2);
            this.pst.setInt(2, servicio.getIdServicio());
            this.pst.executeUpdate();
            System.out.println("Se report\u00f3 correctamente el Servicio: " + servicio.getNombreServicio());
            return;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            try {
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void repairService(Servicio servicio) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        CategoriaServicioDAO categoriaServicioDAO = new CategoriaServicioDAO();
        EstadoServicioDAO estadoServicioDAO = new EstadoServicioDAO();
        String sql = "UPDATE servicios SET id_estado_servicio = ? WHERE id_servicio = ?";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, 1);
            this.pst.setInt(2, servicio.getIdServicio());
            this.pst.executeUpdate();
            System.out.println("Se report\u00f3 correctamente el Servicio: " + servicio.getNombreServicio());
            return;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            try {
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

