/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.sendreport.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.sendreport.connections.DBConnection;
import mx.com.videoturismo.sendreport.connections.PoolConnection;
import mx.com.videoturismo.sendreport.daos.INivelMarcaDAO;
import mx.com.videoturismo.sendreport.models.NivelMarca;

public class NivelMarcaDAO
implements INivelMarcaDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<NivelMarca> listAll() {
        ArrayList<NivelMarca> listaNivelesMarca = new ArrayList<NivelMarca>();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM niveles_marca ORDER BY id_nivel_marca";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idNivelMarca = this.rs.getInt("id_nivel_marca");
                String nivelMarca = this.rs.getString("nivel_marca");
                NivelMarca tipoRuta1 = new NivelMarca(idNivelMarca, nivelMarca);
                listaNivelesMarca.add(tipoRuta1);
            }
            System.out.println("Se listaron correctamente todos los NivelMarca");
            return listaNivelesMarca;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaNivelesMarca;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NivelMarca list(NivelMarca nivelMarca) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM niveles_marca WHERE id_nivel_marca = ? ORDER BY id_nivel_marca";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, nivelMarca.getIdNivelMarca());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idNivelMarca = this.rs.getInt("id_nivel_marca");
                String nivelMarca1 = this.rs.getString("nivel_marca");
                nivelMarca.setNivelMarca(nivelMarca1);
            }
            System.out.println("Se list\u00f3 correctamente el NivelMarca");
            return nivelMarca;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return nivelMarca;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

