/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.sendreport.daos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.sendreport.connections.DBConnection;
import mx.com.videoturismo.sendreport.connections.PoolConnection;
import mx.com.videoturismo.sendreport.daos.EstadoMarcaDAO;
import mx.com.videoturismo.sendreport.daos.IMarcaDAO;
import mx.com.videoturismo.sendreport.daos.NivelMarcaDAO;
import mx.com.videoturismo.sendreport.models.EstadoMarca;
import mx.com.videoturismo.sendreport.models.Marca;
import mx.com.videoturismo.sendreport.models.NivelMarca;

public class MarcaDAO
implements IMarcaDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Marca> listAll() {
        ArrayList<Marca> listaMarcas = new ArrayList<Marca>();
        NivelMarcaDAO nivelMarcaDAO = new NivelMarcaDAO();
        EstadoMarcaDAO estadoMarcaDAO = new EstadoMarcaDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM marcas ORDER BY id_marca";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idMarca = this.rs.getInt("id_marca");
                String nombreMarca = this.rs.getString("nombre_marca");
                String nombreCarpetaMarca = this.rs.getString("nombre_carpeta_marca");
                int idNivelMarca = this.rs.getInt("id_nivel_marca");
                int idEstadoMarca = this.rs.getInt("id_estado_marca");
                Date fechaCaducidad = this.rs.getDate("fecha_caducidad");
                Date fechaAltaMarca = this.rs.getDate("fecha_alta_marca");
                this.poolConnection.checkIn(this.cnn);
                NivelMarca nivelMarca = nivelMarcaDAO.list(new NivelMarca(idNivelMarca));
                EstadoMarca estadoMarca = estadoMarcaDAO.list(new EstadoMarca(idEstadoMarca));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Marca marca = new Marca(idMarca, nombreMarca, nombreCarpetaMarca, nivelMarca, estadoMarca, fechaCaducidad, fechaAltaMarca);
                listaMarcas.add(marca);
            }
            System.out.println("Se listaron correctamente todas las Marca");
            return listaMarcas;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaMarcas;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Marca list(Marca marca) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        NivelMarcaDAO nivelMarcaDAO = new NivelMarcaDAO();
        EstadoMarcaDAO estadoMarcaDAO = new EstadoMarcaDAO();
        String sql = "SELECT * FROM marcas WHERE id_marca = ? ORDER BY id_marca";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, marca.getIdMarca());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idMarca = this.rs.getInt("id_marca");
                String nombreMarca = this.rs.getString("nombre_marca");
                String nombreCarpetaMarca = this.rs.getString("nombre_carpeta_marca");
                int idNivelMarca = this.rs.getInt("id_nivel_marca");
                int idEstadoMarca = this.rs.getInt("id_estado_marca");
                Date fechaCaducidad = this.rs.getDate("fecha_caducidad");
                Date fechaAltaMarca = this.rs.getDate("fecha_alta_marca");
                this.poolConnection.checkIn(this.cnn);
                NivelMarca nivelMarca = nivelMarcaDAO.list(new NivelMarca(idNivelMarca));
                EstadoMarca estadoMarca = estadoMarcaDAO.list(new EstadoMarca(idEstadoMarca));
                this.cnn = (Connection)this.poolConnection.checkOut();
                marca.setNombreMarca(nombreMarca);
                marca.setNombreCarpetaMarca(nombreCarpetaMarca);
                marca.setNivelMarca(nivelMarca);
                marca.setEstadoMarca(estadoMarca);
                marca.setFechaCaducidad(fechaCaducidad);
                marca.setFechaAltaMarca(fechaAltaMarca);
            }
            System.out.println("Se list\u00f3 correctamente la Marca");
            return marca;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return marca;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

