/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.sendreport.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.sendreport.connections.DBConnection;
import mx.com.videoturismo.sendreport.connections.PoolConnection;
import mx.com.videoturismo.sendreport.daos.IEstadoServicioDAO;
import mx.com.videoturismo.sendreport.models.EstadoServicio;

public class EstadoServicioDAO
implements IEstadoServicioDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<EstadoServicio> listAll() {
        ArrayList<EstadoServicio> listaEstadosServicio = new ArrayList<EstadoServicio>();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM estados_servicio ORDER BY id_estado_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                String estadoServicio = this.rs.getString("estado_servicio");
                EstadoServicio estadoServicio1 = new EstadoServicio(idEstadoServicio, estadoServicio);
                listaEstadosServicio.add(estadoServicio1);
            }
            System.out.println("Se listaron correctamente todos los EstadoServicio");
            return listaEstadosServicio;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaEstadosServicio;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EstadoServicio list(EstadoServicio estadoServicio) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM estados_servicio WHERE id_estado_servicio = ? ORDER BY id_estado_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, estadoServicio.getIdEstadoServicio());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEstadoServicio = this.rs.getInt("id_estado_servicio");
                String estadoServicio1 = this.rs.getString("estado_servicio");
                estadoServicio.setEstadoServicio(estadoServicio1);
            }
            System.out.println("Se list\u00f3 correctamente el EstadoServicio");
            return estadoServicio;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return estadoServicio;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

