/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.sendreport.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.sendreport.connections.DBConnection;
import mx.com.videoturismo.sendreport.connections.PoolConnection;
import mx.com.videoturismo.sendreport.daos.ICategoriaServicioDAO;
import mx.com.videoturismo.sendreport.models.CategoriaServicio;

public class CategoriaServicioDAO
implements ICategoriaServicioDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<CategoriaServicio> listAll() {
        ArrayList<CategoriaServicio> listaCategoriasServicio = new ArrayList<CategoriaServicio>();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM categorias_servicio ORDER BY id_categoria_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idCategoriaServicio = this.rs.getInt("id_categoria_servicio");
                String nombreCategoriaServicio = this.rs.getString("nombre_categoria_servicio");
                CategoriaServicio categoriaServicio1 = new CategoriaServicio(idCategoriaServicio, nombreCategoriaServicio);
                listaCategoriasServicio.add(categoriaServicio1);
            }
            System.out.println("Se listaron correctamente todos los CategoriaServicio");
            return listaCategoriasServicio;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaCategoriasServicio;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CategoriaServicio list(CategoriaServicio categoriaServicio) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM categorias_servicio WHERE id_categoria_servicio = ? ORDER BY id_categoria_servicio";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, categoriaServicio.getIdCategoriaServicio());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idCategoriaServicio = this.rs.getInt("id_categoria_servicio");
                String nombreCategoriaServicio = this.rs.getString("nombre_categoria_servicio");
                categoriaServicio.setNombreCategoriaServicio(nombreCategoriaServicio);
            }
            System.out.println("Se list\u00f3 correctamente el CategoriaServicio");
            return categoriaServicio;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return categoriaServicio;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

