/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.sendreport.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import mx.com.videoturismo.sendreport.connections.DBConnection;
import mx.com.videoturismo.sendreport.connections.PoolConnection;
import mx.com.videoturismo.sendreport.daos.AutobusDAO;
import mx.com.videoturismo.sendreport.daos.IAutobusLocalDAO;
import mx.com.videoturismo.sendreport.models.Autobus;
import mx.com.videoturismo.sendreport.models.AutobusLocal;

public class AutobusLocalDAO
implements IAutobusLocalDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AutobusLocal list() {
        AutobusDAO autobusDAO = new AutobusDAO();
        AutobusLocal autobusLocal = new AutobusLocal();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM autobus_local ORDER BY id_autobus_local";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idAutobusLocal = this.rs.getInt("id_autobus_local");
                int idAutobus = this.rs.getInt("id_autobus");
                this.poolConnection.checkIn(this.cnn);
                Autobus autobus = autobusDAO.list(new Autobus(idAutobus));
                autobusLocal = new AutobusLocal(idAutobusLocal, autobus);
                this.cnn = (Connection)this.poolConnection.checkOut();
            }
            System.out.println("Se listaron correctamente todos los AutobusLocal");
            return autobusLocal;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return autobusLocal;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

