/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.sendreport.daos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.sendreport.connections.DBConnection;
import mx.com.videoturismo.sendreport.connections.PoolConnection;
import mx.com.videoturismo.sendreport.daos.EstadoAutobusDAO;
import mx.com.videoturismo.sendreport.daos.IAutobusDAO;
import mx.com.videoturismo.sendreport.daos.MarcaDAO;
import mx.com.videoturismo.sendreport.models.Autobus;
import mx.com.videoturismo.sendreport.models.EstadoAutobus;
import mx.com.videoturismo.sendreport.models.Marca;

public class AutobusDAO
implements IAutobusDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Autobus> listAll() {
        ArrayList<Autobus> listaAutobuses = new ArrayList<Autobus>();
        MarcaDAO marcaDAO = new MarcaDAO();
        EstadoAutobusDAO estadoAutobusDAO = new EstadoAutobusDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM autobuses ORDER BY id_autobus";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idAutobus = this.rs.getInt("id_autobus");
                int idMarca = this.rs.getInt("id_marca");
                String numeroAutobus = this.rs.getString("numero_autobus");
                int idEstadoAutobus = this.rs.getInt("id_estado_autobus");
                Date fechaAltaAutobus = this.rs.getDate("fecha_alta_autobus");
                this.poolConnection.checkIn(this.cnn);
                Marca marca = marcaDAO.list(new Marca(idMarca));
                EstadoAutobus estadoAutobus = estadoAutobusDAO.list(new EstadoAutobus(idEstadoAutobus));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Autobus autobus = new Autobus(idAutobus, marca, numeroAutobus, estadoAutobus, fechaAltaAutobus);
                listaAutobuses.add(autobus);
            }
            System.out.println("Se listaron correctamente todos los Autobus");
            return listaAutobuses;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaAutobuses;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Autobus list(Autobus autobus) {
        MarcaDAO marcaDAO = new MarcaDAO();
        EstadoAutobusDAO estadoAutobusDAO = new EstadoAutobusDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM autobuses WHERE id_autobus = ? ORDER BY id_autobus";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, autobus.getIdAutobus());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idAutobus = this.rs.getInt("id_autobus");
                int idMarca = this.rs.getInt("id_marca");
                String numeroAutobus = this.rs.getString("numero_autobus");
                int idEstadoAutobus = this.rs.getInt("id_estado_autobus");
                Date fechaAltaAutobus = this.rs.getDate("fecha_alta_autobus");
                this.poolConnection.checkIn(this.cnn);
                Marca marca = marcaDAO.list(new Marca(idMarca));
                EstadoAutobus estadoAutobus = estadoAutobusDAO.list(new EstadoAutobus(idEstadoAutobus));
                this.cnn = (Connection)this.poolConnection.checkOut();
                autobus.setMarca(marca);
                autobus.setNumeroAutobus(numeroAutobus);
                autobus.setEstadoAutobus(estadoAutobus);
                autobus.setFechaAltaAutobus(fechaAltaAutobus);
            }
            System.out.println("Se list\u00f3 correctamente la Autobus");
            return autobus;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return autobus;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

