/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.sendreport.connections;

import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Pool<T> {
    private long expirationTime = 120000L;
    private Hashtable<T, Long> locked = new Hashtable();
    private Hashtable<T, Long> unlocked = new Hashtable();

    protected abstract T create();

    public abstract boolean validate(T var1);

    public abstract void expire(T var1);

    public synchronized T checkOut() {
        T t;
        long now = System.currentTimeMillis();
        if (this.unlocked.size() > 0) {
            Enumeration<T> e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                t = e.nextElement();
                if (now - this.unlocked.get(t) > this.expirationTime) {
                    this.unlocked.remove(t);
                    this.expire(t);
                    t = null;
                    continue;
                }
                if (this.validate(t)) {
                    this.unlocked.remove(t);
                    this.locked.put(t, now);
                    System.out.println("Se devolvi\u00f3 la misma conexi\u00f3n");
                    return t;
                }
                this.unlocked.remove(t);
                this.expire(t);
                t = null;
            }
        }
        t = this.create();
        this.locked.put(t, now);
        System.out.println("Se cre\u00f3 la conexi\u00f3n por primera vez");
        return t;
    }

    public synchronized void checkIn(T t) {
        this.locked.remove(t);
        this.unlocked.put(t, System.currentTimeMillis());
        System.out.println("La conexi\u00f3n volvi\u00f3 al pool");
    }
}

