/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj;

import java.util.Properties;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.version.Version;

public final class Info {
    private Version version;

    public static Info getInstance() {
        return InfoHolder.INSTANCE;
    }

    private Info() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/build.properties"));
            this.version = new Version(properties.getProperty("build.version"));
        }
        catch (Exception e) {
            this.version = null;
        }
        Logger.info("vlcj: {}", this.version != null ? this.version : "<version not available>");
        Logger.info("java: {} {}", System.getProperty("java.version"), System.getProperty("java.vendor"));
        Logger.info("java home: {}", System.getProperty("java.home"));
        Logger.info("os: {} {} {}", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public final Version version() {
        return this.version;
    }

    private static class InfoHolder {
        public static final Info INSTANCE = new Info();

        private InfoHolder() {
        }
    }
}

