/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mx.com.videoturismo.screensbuscontrolpanel.daos.AutobusDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.AutobusLocalDAO;
import mx.com.videoturismo.screensbuscontrolpanel.functions.Language;
import mx.com.videoturismo.screensbuscontrolpanel.gui.MessageDialog;
import mx.com.videoturismo.screensbuscontrolpanel.models.Autobus;
import mx.com.videoturismo.screensbuscontrolpanel.models.AutobusLocal;

public class NewBrandWindow
extends JDialog {
    Language language = Language.getLocalLanguage();
    private JButton btnAccept;
    private JButton btnCancel;
    private JButton btnCero;
    private JButton btnClean;
    private JButton btnDelete;
    private JButton btnEight;
    private JButton btnFive;
    private JButton btnFour;
    private JButton btnNine;
    private JButton btnOne;
    private JButton btnSeven;
    private JButton btnSix;
    private JButton btnThree;
    private JButton btnTwo;
    private JLabel lblBusNumber;
    private JLabel lblTitle;

    NewBrandWindow(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initializeWindow();
    }

    private void initializeWindow() {
        this.lblTitle.setText(this.language.getProperty("existingBusNumber"));
    }

    private void setBusNumberText(String number) {
        if (this.lblBusNumber.getText().length() >= 0 && this.lblBusNumber.getText().length() <= 6) {
            this.lblBusNumber.setText(this.lblBusNumber.getText() + number);
        }
    }

    private void initComponents() {
        this.btnCancel = new JButton();
        this.btnAccept = new JButton();
        this.lblTitle = new JLabel();
        this.btnOne = new JButton();
        this.btnFour = new JButton();
        this.btnTwo = new JButton();
        this.btnThree = new JButton();
        this.btnSix = new JButton();
        this.btnFive = new JButton();
        this.btnSeven = new JButton();
        this.btnEight = new JButton();
        this.btnNine = new JButton();
        this.btnCero = new JButton();
        this.btnDelete = new JButton();
        this.btnClean = new JButton();
        this.lblBusNumber = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Emergencia");
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 204, 204));
        this.setUndecorated(true);
        this.btnCancel.setFont(new Font("Cantarell", 1, 24));
        this.btnCancel.setText("Cancelar");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnAccept.setFont(new Font("Cantarell", 1, 24));
        this.btnAccept.setText("Aceptar");
        this.btnAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnAcceptActionPerformed(evt);
            }
        });
        this.lblTitle.setFont(new Font("Arial", 1, 24));
        this.lblTitle.setText("TEXTO EDITABLE DEPENDIENDO DEL TIPO DE ACCION");
        this.btnOne.setFont(new Font("Ubuntu", 1, 24));
        this.btnOne.setText("1");
        this.btnOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnOneActionPerformed(evt);
            }
        });
        this.btnFour.setFont(new Font("Ubuntu", 1, 24));
        this.btnFour.setText("4");
        this.btnFour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnFourActionPerformed(evt);
            }
        });
        this.btnTwo.setFont(new Font("Ubuntu", 1, 24));
        this.btnTwo.setText("2");
        this.btnTwo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnTwoActionPerformed(evt);
            }
        });
        this.btnThree.setFont(new Font("Ubuntu", 1, 24));
        this.btnThree.setText("3");
        this.btnThree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnThreeActionPerformed(evt);
            }
        });
        this.btnSix.setFont(new Font("Ubuntu", 1, 24));
        this.btnSix.setText("6");
        this.btnSix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnSixActionPerformed(evt);
            }
        });
        this.btnFive.setFont(new Font("Ubuntu", 1, 24));
        this.btnFive.setText("5");
        this.btnFive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnFiveActionPerformed(evt);
            }
        });
        this.btnSeven.setFont(new Font("Ubuntu", 1, 24));
        this.btnSeven.setText("7");
        this.btnSeven.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnSevenActionPerformed(evt);
            }
        });
        this.btnEight.setFont(new Font("Ubuntu", 1, 24));
        this.btnEight.setText("8");
        this.btnEight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnEightActionPerformed(evt);
            }
        });
        this.btnNine.setFont(new Font("Ubuntu", 1, 24));
        this.btnNine.setText("9");
        this.btnNine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnNineActionPerformed(evt);
            }
        });
        this.btnCero.setFont(new Font("Ubuntu", 1, 24));
        this.btnCero.setText("0");
        this.btnCero.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnCeroActionPerformed(evt);
            }
        });
        this.btnDelete.setFont(new Font("Ubuntu", 1, 18));
        this.btnDelete.setText("Borrar");
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnDeleteActionPerformed(evt);
            }
        });
        this.btnClean.setFont(new Font("Ubuntu", 1, 18));
        this.btnClean.setText("Limpiar");
        this.btnClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrandWindow.this.btnCleanActionPerformed(evt);
            }
        });
        this.lblBusNumber.setFont(new Font("Ubuntu", 1, 120));
        this.lblBusNumber.setHorizontalAlignment(0);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.lblTitle).addGap(0, 150, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(42, 42, 42).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.btnOne, -2, 100, -2).addGap(18, 18, 18).addComponent(this.btnTwo, -2, 100, -2).addGap(18, 18, 18).addComponent(this.btnThree, -2, 100, -2)).addGroup(layout.createSequentialGroup().addComponent(this.btnAccept, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnCancel, -2, 150, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.btnFour, -2, 100, -2).addGap(18, 18, 18).addComponent(this.btnFive, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnSeven, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnClean, -2, 100, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnEight, -1, -1, Short.MAX_VALUE).addComponent(this.btnCero, -2, 100, -2)))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnNine, -1, -1, Short.MAX_VALUE).addComponent(this.btnDelete, -2, 100, -2)).addComponent(this.btnSix, -2, 100, -2)))).addGap(18, 18, 18).addComponent(this.lblBusNumber, -1, -1, Short.MAX_VALUE))).addGap(12, 12, 12)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.lblTitle, -2, 38, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOne, -2, 100, -2).addComponent(this.btnTwo, -2, 100, -2)).addComponent(this.btnThree, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnFour, -1, 100, Short.MAX_VALUE).addComponent(this.btnFive, -1, -1, Short.MAX_VALUE).addComponent(this.btnSix, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnNine, -1, -1, Short.MAX_VALUE).addComponent(this.btnSeven, -1, -1, Short.MAX_VALUE).addComponent(this.btnEight, -2, 100, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnDelete, -1, -1, Short.MAX_VALUE).addComponent(this.btnCero, -1, -1, Short.MAX_VALUE).addComponent(this.btnClean, -2, 100, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAccept, -1, 96, Short.MAX_VALUE).addComponent(this.btnCancel, -1, 96, Short.MAX_VALUE))).addComponent(this.lblBusNumber, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnAcceptActionPerformed(ActionEvent evt) {
        String idBus = this.lblBusNumber.getText();
        AutobusDAO autobusDAO = new AutobusDAO();
        AutobusLocalDAO autobusLocalDAO = new AutobusLocalDAO();
        Autobus autobus = autobusDAO.listAutobusCloud(new Autobus(Integer.parseInt(idBus)));
        if (autobus.getMarca() == null) {
            MessageDialog messageDialog = new MessageDialog(null, true, this.language.getProperty("busNotExists"));
            messageDialog.setLocationRelativeTo(this);
            messageDialog.setVisible(true);
        } else {
            if (autobus.getMarca() != null) {
                autobusDAO.create(autobus);
                if (autobusLocalDAO.update(new AutobusLocal(1, autobus))) {
                    MessageDialog messageDialog = new MessageDialog(null, true, this.language.getProperty("brandChanged"));
                    messageDialog.setLocationRelativeTo(this);
                    messageDialog.setVisible(true);
                } else {
                    MessageDialog messageDialog = new MessageDialog(null, true, this.language.getProperty("brandChangedError"));
                    messageDialog.setLocationRelativeTo(this);
                    messageDialog.setVisible(true);
                }
            }
            this.dispose();
        }
    }

    private void btnOneActionPerformed(ActionEvent evt) {
        this.setBusNumberText("1");
    }

    private void btnTwoActionPerformed(ActionEvent evt) {
        this.setBusNumberText("2");
    }

    private void btnThreeActionPerformed(ActionEvent evt) {
        this.setBusNumberText("3");
    }

    private void btnFourActionPerformed(ActionEvent evt) {
        this.setBusNumberText("4");
    }

    private void btnFiveActionPerformed(ActionEvent evt) {
        this.setBusNumberText("5");
    }

    private void btnSixActionPerformed(ActionEvent evt) {
        this.setBusNumberText("6");
    }

    private void btnSevenActionPerformed(ActionEvent evt) {
        this.setBusNumberText("7");
    }

    private void btnEightActionPerformed(ActionEvent evt) {
        this.setBusNumberText("8");
    }

    private void btnNineActionPerformed(ActionEvent evt) {
        this.setBusNumberText("9");
    }

    private void btnCeroActionPerformed(ActionEvent evt) {
        this.setBusNumberText("0");
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        if (this.lblBusNumber.getText().length() != 0) {
            this.lblBusNumber.setText(this.lblBusNumber.getText().substring(0, this.lblBusNumber.getText().length() - 1));
        }
    }

    private void btnCleanActionPerformed(ActionEvent evt) {
        if (this.lblBusNumber.getText().length() != 0) {
            this.lblBusNumber.setText("");
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(NewBrandWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(NewBrandWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NewBrandWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(NewBrandWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewBrandWindow dialog = new NewBrandWindow((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

