/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mx.com.videoturismo.screensbuscontrolpanel.daos.AutobusDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.AutobusLocalDAO;
import mx.com.videoturismo.screensbuscontrolpanel.functions.Language;
import mx.com.videoturismo.screensbuscontrolpanel.gui.MessageDialog;
import mx.com.videoturismo.screensbuscontrolpanel.models.Autobus;
import mx.com.videoturismo.screensbuscontrolpanel.models.AutobusLocal;

public class ChangeBusWindow
extends JDialog {
    Language language = Language.getLocalLanguage();
    DefaultListModel<Autobus> autobusesListModel = new DefaultListModel();
    List<Autobus> autobusesList = new ArrayList<Autobus>();
    private JButton btnAccept;
    private JButton btnCancel;
    private JList<Autobus> jList1;
    private JScrollPane jScrollPane2;
    private JLabel lblTitle;

    ChangeBusWindow(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initializeWindow();
        DefaultListCellRenderer renderer = (DefaultListCellRenderer)this.jList1.getCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.loadBuses();
    }

    private void initializeWindow() {
        this.lblTitle.setText(this.language.getProperty("selectBus"));
    }

    private void loadBuses() {
        AutobusDAO autobusDAO = new AutobusDAO();
        this.autobusesList = autobusDAO.listAll();
        for (Autobus autobus : this.autobusesList) {
            this.autobusesListModel.addElement(autobus);
        }
    }

    private void initComponents() {
        this.btnCancel = new JButton();
        this.btnAccept = new JButton();
        this.lblTitle = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 204, 204));
        this.setUndecorated(true);
        this.btnCancel.setFont(new Font("Cantarell", 1, 24));
        this.btnCancel.setText("Cancelar");
        this.btnCancel.setText(this.language.getProperty("cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeBusWindow.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnAccept.setFont(new Font("Cantarell", 1, 24));
        this.btnAccept.setText("Aceptar");
        this.btnAccept.setText(this.language.getProperty("accept"));
        this.btnAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeBusWindow.this.btnAcceptActionPerformed(evt);
            }
        });
        this.lblTitle.setFont(new Font("Arial", 1, 24));
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setText("TEXTO EDITABLE DEPENDIENDO DEL TIPO DE ACCION");
        this.jList1.setFont(new Font("Ubuntu", 1, 48));
        this.jList1.setModel(this.autobusesListModel);
        this.jScrollPane2.setViewportView(this.jList1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnAccept, -2, 160, -2).addGap(18, 18, 18).addComponent(this.btnCancel, -2, 160, -2).addGap(208, 208, 208)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle, -1, 788, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.lblTitle, -2, 38, -2).addGap(18, 18, 18).addComponent(this.jScrollPane2, -2, 460, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAccept, -1, 96, Short.MAX_VALUE).addComponent(this.btnCancel, -1, 96, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void btnAcceptActionPerformed(ActionEvent evt) {
        AutobusLocalDAO autobusLocalDAO = new AutobusLocalDAO();
        if (this.jList1.getSelectedValue() != null) {
            Autobus autobus = this.jList1.getSelectedValue();
            if (autobusLocalDAO.update(new AutobusLocal(1, autobus))) {
                MessageDialog messageDialog = new MessageDialog(null, true, this.language.getProperty("busChanged"));
                messageDialog.setLocationRelativeTo(this);
                messageDialog.setVisible(true);
            } else {
                MessageDialog messageDialog = new MessageDialog(null, true, this.language.getProperty("busChangedError"));
                messageDialog.setLocationRelativeTo(this);
                messageDialog.setVisible(true);
            }
            this.dispose();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ChangeBusWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ChangeBusWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ChangeBusWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ChangeBusWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeBusWindow dialog = new ChangeBusWindow((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

