/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mx.com.videoturismo.screensbuscontrolpanel.daos.ServicioDAO;
import mx.com.videoturismo.screensbuscontrolpanel.functions.Language;
import mx.com.videoturismo.screensbuscontrolpanel.gui.ConfirmDialog;
import mx.com.videoturismo.screensbuscontrolpanel.gui.EmployeeNumberWindow;
import mx.com.videoturismo.screensbuscontrolpanel.models.CategoriaServicio;
import mx.com.videoturismo.screensbuscontrolpanel.models.Servicio;

public class Category3Services
extends JDialog {
    Language language = Language.getLocalLanguage();
    int idCat;
    List<Servicio> servicios = new ArrayList<Servicio>();
    ServicioDAO servicioDAO = new ServicioDAO();
    private JButton btnExit;
    private JButton btnService1;
    private JButton btnService2;
    private JButton btnService3;

    public Category3Services(Frame parent, boolean modal, int idCat) {
        super(parent, modal);
        this.initComponents();
        this.idCat = idCat;
        this.initializeButtonTexts();
        this.comprobeServicesColor();
    }

    private void initializeButtonTexts() {
        this.servicios = this.servicioDAO.listAllByCategory(new CategoriaServicio(this.idCat));
        this.btnService1.setText(this.servicios.get(0).getNombreServicio());
        this.btnService2.setText(this.servicios.get(1).getNombreServicio());
        this.btnService3.setText(this.servicios.get(2).getNombreServicio());
    }

    private void comprobeServicesColor() {
        if (this.servicioDAO.isServiceReported(this.servicios.get(0))) {
            this.btnService1.setBackground(Color.red);
        } else {
            this.btnService1.setBackground(Color.blue);
        }
        if (this.servicioDAO.isServiceReported(this.servicios.get(1))) {
            this.btnService2.setBackground(Color.red);
        } else {
            this.btnService2.setBackground(Color.blue);
        }
        if (this.servicioDAO.isServiceReported(this.servicios.get(2))) {
            this.btnService3.setBackground(Color.red);
        } else {
            this.btnService3.setBackground(Color.blue);
        }
    }

    private void reportService(Servicio servicio) {
        ConfirmDialog confirmDialog = new ConfirmDialog(null, true, this.language.getProperty("reportService"));
        confirmDialog.setLocationRelativeTo(this);
        boolean opc = confirmDialog.showDialog();
        if (opc) {
            this.servicioDAO.reportService(servicio);
            this.comprobeServicesColor();
        }
    }

    private void repairService(Servicio servicio) {
        ConfirmDialog confirmDialog = new ConfirmDialog(null, true, this.language.getProperty("repairService"));
        confirmDialog.setLocationRelativeTo(this);
        boolean opc = confirmDialog.showDialog();
        if (opc) {
            EmployeeNumberWindow employeeNumberWindow = new EmployeeNumberWindow(null, true, 1, servicio);
            employeeNumberWindow.setLocationRelativeTo(this);
            employeeNumberWindow.setVisible(true);
            this.comprobeServicesColor();
        }
    }

    private void initComponents() {
        this.btnService3 = new JButton();
        this.btnService1 = new JButton();
        this.btnService2 = new JButton();
        this.btnExit = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.setResizable(false);
        this.btnService3.setFont(new Font("Cantarell", 1, 36));
        this.btnService3.setText("SERVICIO NUMERO 3333333");
        this.btnService3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Category3Services.this.btnService3ActionPerformed(evt);
            }
        });
        this.btnService1.setFont(new Font("Cantarell", 1, 36));
        this.btnService1.setText("SERVICIO NUMERO 1111111");
        this.btnService1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Category3Services.this.btnService1ActionPerformed(evt);
            }
        });
        this.btnService2.setFont(new Font("Cantarell", 1, 36));
        this.btnService2.setText("SERVICIO NUMERO 2222222");
        this.btnService2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Category3Services.this.btnService2ActionPerformed(evt);
            }
        });
        this.btnExit.setFont(new Font("Cantarell", 1, 36));
        this.btnExit.setText("Salir");
        this.btnExit.setText(this.language.getProperty("exit"));
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Category3Services.this.btnExitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnExit, -1, -1, Short.MAX_VALUE).addComponent(this.btnService1, -1, -1, Short.MAX_VALUE).addComponent(this.btnService2, GroupLayout.Alignment.LEADING, -1, 597, Short.MAX_VALUE).addComponent(this.btnService3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.btnService1, -2, 130, -2).addGap(18, 18, 18).addComponent(this.btnService2, -2, 130, -2).addGap(18, 18, 18).addComponent(this.btnService3, -2, 130, -2).addGap(18, 18, 18).addComponent(this.btnExit, -2, 130, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnService1ActionPerformed(ActionEvent evt) {
        if (this.servicioDAO.isServiceReported(this.servicios.get(0))) {
            this.repairService(this.servicios.get(0));
        } else {
            this.reportService(this.servicios.get(0));
        }
    }

    private void btnService2ActionPerformed(ActionEvent evt) {
        if (this.servicioDAO.isServiceReported(this.servicios.get(1))) {
            this.repairService(this.servicios.get(1));
        } else {
            this.reportService(this.servicios.get(1));
        }
    }

    private void btnService3ActionPerformed(ActionEvent evt) {
        if (this.servicioDAO.isServiceReported(this.servicios.get(2))) {
            this.repairService(this.servicios.get(2));
        } else {
            this.reportService(this.servicios.get(2));
        }
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Category3Services.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Category3Services.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Category3Services.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Category3Services.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Category3Services dialog = new Category3Services((Frame)new JFrame(), true, 0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

