/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.AutobusDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.AutobusLocalDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.IRutaDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.MarcaDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.TipoRutaDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.AutobusLocal;
import mx.com.videoturismo.screensbuscontrolpanel.models.Marca;
import mx.com.videoturismo.screensbuscontrolpanel.models.Ruta;
import mx.com.videoturismo.screensbuscontrolpanel.models.TipoRuta;

public class RutaDAO
implements IRutaDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Ruta> listAll() {
        ArrayList<Ruta> listaRutas = new ArrayList<Ruta>();
        AutobusLocalDAO autobusLocalDAO = new AutobusLocalDAO();
        AutobusDAO autobusDAO = new AutobusDAO();
        MarcaDAO marcaDAO = new MarcaDAO();
        TipoRutaDAO tipoRutaDAO = new TipoRutaDAO();
        AutobusLocal autobusLocal = autobusLocalDAO.list();
        this.cnn = (Connection)this.poolConnection.checkOut();
        try {
            String sql = "SELECT * FROM rutas WHERE id_marca = ? ORDER BY id_ruta";
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, autobusLocal.getAutobus().getMarca().getIdMarca());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idRuta = this.rs.getInt("id_ruta");
                int idMarca = this.rs.getInt("id_marca");
                int idTipoRuta = this.rs.getInt("id_tipo_ruta");
                String origen = this.rs.getString("origen");
                String destino = this.rs.getString("destino");
                int duracionRuta = this.rs.getInt("duracion_ruta");
                this.poolConnection.checkIn(this.cnn);
                Marca marca = marcaDAO.list(new Marca(idMarca));
                TipoRuta tipoRuta = tipoRutaDAO.list(new TipoRuta(idTipoRuta));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Ruta ruta = new Ruta(idRuta, marca, tipoRuta, origen, destino, duracionRuta);
                listaRutas.add(ruta);
            }
            System.out.println("Se listaron correctamente todas las Ruta");
            return listaRutas;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaRutas;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Ruta list(Ruta ruta) {
        MarcaDAO marcaDAO = new MarcaDAO();
        TipoRutaDAO tipoRutaDAO = new TipoRutaDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM rutas WHERE id_ruta = ? ORDER BY id_ruta";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, ruta.getIdRuta());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idRuta = this.rs.getInt("id_ruta");
                int idMarca = this.rs.getInt("id_marca");
                int idTipoRuta = this.rs.getInt("id_tipo_ruta");
                String origen = this.rs.getString("origen");
                String destino = this.rs.getString("destino");
                int duracionRuta = this.rs.getInt("duracion_ruta");
                this.poolConnection.checkIn(this.cnn);
                Marca marca = marcaDAO.list(new Marca(idMarca));
                TipoRuta tipoRuta = tipoRutaDAO.list(new TipoRuta(idTipoRuta));
                this.cnn = (Connection)this.poolConnection.checkOut();
                ruta.setMarca(marca);
                ruta.setTipoRuta(tipoRuta);
                ruta.setOrigen(origen);
                ruta.setDestino(destino);
                ruta.setDuracionRuta(duracionRuta);
            }
            System.out.println("Se list\u00f3 correctamente la Ruta");
            return ruta;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return ruta;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean comprobeRoute(Ruta ruta) {
        boolean exists = false;
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM rutas WHERE id_ruta = ?";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, ruta.getIdRuta());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                exists = true;
            }
            System.out.println("Se comprob\u00f3 la existencia de la Ruta");
            return exists;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return exists;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

