/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.IPublicidadDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.Publicidad;

public class PublicidadDAO
implements IPublicidadDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Publicidad> listAll() {
        ArrayList<Publicidad> listaPublicidades = new ArrayList<Publicidad>();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM publicidades ORDER BY id_publicidad";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idPublicidad = this.rs.getInt("id_publicidad");
                String tituloPublicidad = this.rs.getString("titulo_publicidad");
                String nombreArchivoPublicidad = this.rs.getString("nombre_archivo_publicidad");
                String locacionArchivoPublicidad = this.rs.getString("locacion_archivo_publicidad");
                int duracionPublicidad = this.rs.getInt("duracion_publicidad");
                int prioridadPublicidad = this.rs.getInt("prioridad_publicidad");
                Date fechaAltaPublicidad = this.rs.getDate("fecha_alta_publicidad");
                int impactosPublicidad = this.rs.getInt("impactos_publicidad");
                Publicidad publicidad = new Publicidad(idPublicidad, tituloPublicidad, nombreArchivoPublicidad, locacionArchivoPublicidad, duracionPublicidad, prioridadPublicidad, fechaAltaPublicidad, impactosPublicidad);
                listaPublicidades.add(publicidad);
            }
            System.out.println("Se listaron correctamente todas las Publicidades");
            return listaPublicidades;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaPublicidades;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Publicidad list(Publicidad publicidad) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM publicidades WHERE id_publicidad = ? ORDER BY id_publicidad";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, publicidad.getIdPublicidad());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idPublicidad = this.rs.getInt("id_publicidad");
                String tituloPublicidad = this.rs.getString("titulo_publicidad");
                String nombreArchivoPublicidad = this.rs.getString("nombre_archivo_publicidad");
                String locacionArchivoPublicidad = this.rs.getString("locacion_archivo_publicidad");
                int duracionPublicidad = this.rs.getInt("duracion_publicidad");
                int prioridadPublicidad = this.rs.getInt("prioridad_publicidad");
                Date fechaAltaPublicidad = this.rs.getDate("fecha_alta_publicidad");
                int impactosPublicidad = this.rs.getInt("impactos_publicidad");
                publicidad.setTituloPublicidad(tituloPublicidad);
                publicidad.setNombreArchivoPublicidad(nombreArchivoPublicidad);
                publicidad.setLocacionArchivoPublicidad(locacionArchivoPublicidad);
                publicidad.setDuracionPublicidad(duracionPublicidad);
                publicidad.setPrioridadPublicidad(prioridadPublicidad);
                publicidad.setFechaAltaPublicidad(fechaAltaPublicidad);
                publicidad.setImpactosPublicidad(impactosPublicidad);
            }
            System.out.println("Se list\u00f3 correctamente la Publicidad");
            return publicidad;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return publicidad;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Publicidad listByTitle(Publicidad publicidad) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM publicidades WHERE titulo_publicidad = ? ORDER BY id_publicidad";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setString(1, publicidad.getTituloPublicidad());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idPublicidad = this.rs.getInt("id_publicidad");
                String tituloPublicidad = this.rs.getString("titulo_publicidad");
                String nombreArchivoPublicidad = this.rs.getString("nombre_archivo_publicidad");
                String locacionArchivoPublicidad = this.rs.getString("locacion_archivo_publicidad");
                int duracionPublicidad = this.rs.getInt("duracion_publicidad");
                int prioridadPublicidad = this.rs.getInt("prioridad_publicidad");
                Date fechaAltaPublicidad = this.rs.getDate("fecha_alta_publicidad");
                int impactosPublicidad = this.rs.getInt("impactos_publicidad");
                publicidad.setIdPublicidad(idPublicidad);
                publicidad.setTituloPublicidad(tituloPublicidad);
                publicidad.setNombreArchivoPublicidad(nombreArchivoPublicidad);
                publicidad.setLocacionArchivoPublicidad(locacionArchivoPublicidad);
                publicidad.setDuracionPublicidad(duracionPublicidad);
                publicidad.setPrioridadPublicidad(prioridadPublicidad);
                publicidad.setFechaAltaPublicidad(fechaAltaPublicidad);
                publicidad.setImpactosPublicidad(impactosPublicidad);
            }
            System.out.println("Se list\u00f3 correctamente la Publicidad");
            return publicidad;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return publicidad;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Publicidad updateImpacts(Publicidad publicidad) {
        publicidad = this.listByTitle(publicidad);
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "UPDATE publicidades SET impactos_publicidad = ? WHERE id_publicidad = ?";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, publicidad.getImpactosPublicidad() + 1);
            this.pst.setInt(2, publicidad.getIdPublicidad());
            this.pst.executeUpdate();
            System.out.println("Se agreg\u00f3 correctamente el impacto a la publicidad: " + publicidad.getTituloPublicidad());
            return publicidad;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return publicidad;
        }
        finally {
            try {
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

