/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.GeneroPeliculaDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.IPeliculaDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.GeneroPelicula;
import mx.com.videoturismo.screensbuscontrolpanel.models.Pelicula;

public class PeliculaDAO
implements IPeliculaDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Pelicula> listAll() {
        ArrayList<Pelicula> listaPeliculas = new ArrayList<Pelicula>();
        GeneroPeliculaDAO generoPeliculaDAO = new GeneroPeliculaDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM peliculas ORDER BY id_pelicula";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idPelicula = this.rs.getInt("id_pelicula");
                int idGeneroPelicula = this.rs.getInt("id_genero_pelicula");
                String tituloPelicula = this.rs.getString("titulo_pelicula");
                String nombreArchivoPelicula = this.rs.getString("nombre_archivo_pelicula");
                String nombrePortadaPelicula = this.rs.getString("nombre_portada_pelicula");
                String locacionArchivoPelicula = this.rs.getString("locacion_archivo_pelicula");
                String locacionPortadaPelicula = this.rs.getString("locacion_portada_pelicula");
                String sinopsisPelicula = this.rs.getString("sinopsis_pelicula");
                int duracionPelicula = this.rs.getInt("duracion_pelicula");
                Date fechaAltaPelicula = this.rs.getDate("fecha_alta_pelicula");
                Date fechaInicioPelicula = this.rs.getDate("fecha_inicio_pelicula");
                Date fechaFinPelicula = this.rs.getDate("fecha_fin_pelicula");
                int impactosPelicula = this.rs.getInt("impactos_pelicula");
                int vistasPelicula = this.rs.getInt("vistas_pelicula");
                this.poolConnection.checkIn(this.cnn);
                GeneroPelicula generoPelicula = generoPeliculaDAO.list(new GeneroPelicula(idGeneroPelicula));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Pelicula pelicula = new Pelicula(idPelicula, generoPelicula, tituloPelicula, nombreArchivoPelicula, nombrePortadaPelicula, locacionArchivoPelicula, locacionPortadaPelicula, sinopsisPelicula, duracionPelicula, fechaAltaPelicula, fechaInicioPelicula, fechaFinPelicula, impactosPelicula, vistasPelicula);
                listaPeliculas.add(pelicula);
            }
            System.out.println("Se listaron correctamente todas las Pelicula");
            return listaPeliculas;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaPeliculas;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pelicula list(Pelicula pelicula) {
        GeneroPeliculaDAO generoPeliculaDAO = new GeneroPeliculaDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM peliculas WHERE id_pelicula = ? ORDER BY id_pelicula";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, pelicula.getIdPelicula());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idPelicula = this.rs.getInt("id_pelicula");
                int idGeneroPelicula = this.rs.getInt("id_genero_pelicula");
                String tituloPelicula = this.rs.getString("titulo_pelicula");
                String nombreArchivoPelicula = this.rs.getString("nombre_archivo_pelicula");
                String nombrePortadaPelicula = this.rs.getString("nombre_portada_pelicula");
                String locacionArchivoPelicula = this.rs.getString("locacion_archivo_pelicula");
                String locacionPortadaPelicula = this.rs.getString("locacion_portada_pelicula");
                String sinopsisPelicula = this.rs.getString("sinopsis_pelicula");
                int duracionPelicula = this.rs.getInt("duracion_pelicula");
                Date fechaAltaPelicula = this.rs.getDate("fecha_alta_pelicula");
                Date fechaInicioPelicula = this.rs.getDate("fecha_inicio_pelicula");
                Date fechaFinPelicula = this.rs.getDate("fecha_fin_pelicula");
                int impactosPelicula = this.rs.getInt("impactos_pelicula");
                int vistasPelicula = this.rs.getInt("vistas_pelicula");
                this.poolConnection.checkIn(this.cnn);
                GeneroPelicula generoPelicula = generoPeliculaDAO.list(new GeneroPelicula(idGeneroPelicula));
                this.cnn = (Connection)this.poolConnection.checkOut();
                pelicula.setGeneroPelicula(generoPelicula);
                pelicula.setTituloPelicula(tituloPelicula);
                pelicula.setNombreArchivoPelicula(nombreArchivoPelicula);
                pelicula.setNombrePortadaPelicula(nombrePortadaPelicula);
                pelicula.setLocacionArchivoPelicula(locacionArchivoPelicula);
                pelicula.setLocacionPortadaPelicula(locacionPortadaPelicula);
                pelicula.setSinopsisPelicula(sinopsisPelicula);
                pelicula.setDuracionPelicula(duracionPelicula);
                pelicula.setFechaAltaPelicula(fechaAltaPelicula);
                pelicula.setFechaInicioPelicula(fechaInicioPelicula);
                pelicula.setFechaFinPelicula(fechaFinPelicula);
                pelicula.setImpactosPelicula(impactosPelicula);
                pelicula.setVistasPelicula(vistasPelicula);
            }
            System.out.println("Se list\u00f3 correctamente la Pelicula");
            return pelicula;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return pelicula;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pelicula listByTitle(Pelicula pelicula) {
        GeneroPeliculaDAO generoPeliculaDAO = new GeneroPeliculaDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM peliculas WHERE titulo_pelicula = ? ORDER BY id_pelicula";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setString(1, pelicula.getTituloPelicula());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idPelicula = this.rs.getInt("id_pelicula");
                int idGeneroPelicula = this.rs.getInt("id_genero_pelicula");
                String tituloPelicula = this.rs.getString("titulo_pelicula");
                String nombreArchivoPelicula = this.rs.getString("nombre_archivo_pelicula");
                String nombrePortadaPelicula = this.rs.getString("nombre_portada_pelicula");
                String locacionArchivoPelicula = this.rs.getString("locacion_archivo_pelicula");
                String locacionPortadaPelicula = this.rs.getString("locacion_portada_pelicula");
                String sinopsisPelicula = this.rs.getString("sinopsis_pelicula");
                int duracionPelicula = this.rs.getInt("duracion_pelicula");
                Date fechaAltaPelicula = this.rs.getDate("fecha_alta_pelicula");
                Date fechaInicioPelicula = this.rs.getDate("fecha_inicio_pelicula");
                Date fechaFinPelicula = this.rs.getDate("fecha_fin_pelicula");
                int impactosPelicula = this.rs.getInt("impactos_pelicula");
                int vistasPelicula = this.rs.getInt("vistas_pelicula");
                this.poolConnection.checkIn(this.cnn);
                GeneroPelicula generoPelicula = generoPeliculaDAO.list(new GeneroPelicula(idGeneroPelicula));
                this.cnn = (Connection)this.poolConnection.checkOut();
                pelicula.setIdPelicula(idPelicula);
                pelicula.setGeneroPelicula(generoPelicula);
                pelicula.setTituloPelicula(tituloPelicula);
                pelicula.setNombreArchivoPelicula(nombreArchivoPelicula);
                pelicula.setNombrePortadaPelicula(nombrePortadaPelicula);
                pelicula.setLocacionArchivoPelicula(locacionArchivoPelicula);
                pelicula.setLocacionPortadaPelicula(locacionPortadaPelicula);
                pelicula.setSinopsisPelicula(sinopsisPelicula);
                pelicula.setDuracionPelicula(duracionPelicula);
                pelicula.setFechaAltaPelicula(fechaAltaPelicula);
                pelicula.setFechaInicioPelicula(fechaInicioPelicula);
                pelicula.setFechaFinPelicula(fechaFinPelicula);
                pelicula.setImpactosPelicula(impactosPelicula);
                pelicula.setVistasPelicula(vistasPelicula);
            }
            System.out.println("Se list\u00f3 correctamente la Pelicula");
            return pelicula;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return pelicula;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pelicula updateImpacts(Pelicula pelicula) {
        pelicula = this.listByTitle(pelicula);
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "UPDATE peliculas SET impactos_pelicula = ? WHERE id_pelicula = ?";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, pelicula.getImpactosPelicula() + 1);
            this.pst.setInt(2, pelicula.getIdPelicula());
            this.pst.executeUpdate();
            System.out.println("Se agreg\u00f3 correctamente el impacto a la pelicula: " + pelicula.getTituloPelicula());
            return pelicula;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return pelicula;
        }
        finally {
            try {
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

