/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.CapituloDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.IListaReproduccionDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.PeliculaDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.PublicidadDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.TipoMultimediaDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.Capitulo;
import mx.com.videoturismo.screensbuscontrolpanel.models.ListaReproduccion;
import mx.com.videoturismo.screensbuscontrolpanel.models.Pelicula;
import mx.com.videoturismo.screensbuscontrolpanel.models.Publicidad;
import mx.com.videoturismo.screensbuscontrolpanel.models.TipoMultimedia;

public class ListaReproduccionDAO
implements IListaReproduccionDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ListaReproduccion> listAll() {
        ArrayList<ListaReproduccion> listaListasReproduccion = new ArrayList<ListaReproduccion>();
        TipoMultimediaDAO tipoMultimediaDAO = new TipoMultimediaDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM lista_reproduccion ORDER BY id_lista_reproduccion";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idListaReproduccion = this.rs.getInt("id_lista_reproduccion");
                String tituloMultimedia = this.rs.getString("titulo_multimedia");
                String rutaMultimedia = this.rs.getString("ruta_multimedia");
                int duracionMultimedia = this.rs.getInt("duracion_multimedia");
                int idTipoMultimedia = this.rs.getInt("id_tipo_multimedia");
                this.poolConnection.checkIn(this.cnn);
                TipoMultimedia tipoMultimedia = tipoMultimediaDAO.list(new TipoMultimedia(idTipoMultimedia));
                this.cnn = (Connection)this.poolConnection.checkOut();
                ListaReproduccion listaReproduccion = new ListaReproduccion(idListaReproduccion, tituloMultimedia, rutaMultimedia, duracionMultimedia, tipoMultimedia);
                listaListasReproduccion.add(listaReproduccion);
            }
            System.out.println("Se listaron correctamente todas las ListaReproduccion");
            return listaListasReproduccion;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaListasReproduccion;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ListaReproduccion list(ListaReproduccion listaReproduccion) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        TipoMultimediaDAO tipoMultimediaDAO = new TipoMultimediaDAO();
        String sql = "SELECT * FROM lista_reproduccion WHERE id_lista_reproduccion = ? ORDER BY id_lista_reproduccion";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, listaReproduccion.getIdListaReproduccion());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idListaReproduccion = this.rs.getInt("id_lista_reproduccion");
                String tituloMultimedia = this.rs.getString("titulo_multimedia");
                String rutaMultimedia = this.rs.getString("ruta_multimedia");
                int duracionMultimedia = this.rs.getInt("duracion_multimedia");
                int idTipoMultimedia = this.rs.getInt("id_tipo_multimedia");
                this.poolConnection.checkIn(this.cnn);
                TipoMultimedia tipoMultimedia = tipoMultimediaDAO.list(new TipoMultimedia(idTipoMultimedia));
                this.cnn = (Connection)this.poolConnection.checkOut();
                listaReproduccion.setTituloMultimedia(tituloMultimedia);
                listaReproduccion.setRutaMultimedia(rutaMultimedia);
                listaReproduccion.setDuracionMultimedia(duracionMultimedia);
                listaReproduccion.setTipoMultimedia(tipoMultimedia);
            }
            System.out.println("Se list\u00f3 correctamente la ListaReproduccion");
            return listaReproduccion;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaReproduccion;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    @Override
    public void addImpacto(ListaReproduccion listaReproduccion) {
        TipoMultimediaDAO tipoMultimediaDAO = new TipoMultimediaDAO();
        boolean currentImpactos = false;
        switch (listaReproduccion.getTipoMultimedia().getIdTipoMultimedia()) {
            case 1: {
                PublicidadDAO publicidadDAO = new PublicidadDAO();
                Publicidad publicidad = new Publicidad();
                publicidad.setTituloPublicidad(listaReproduccion.getTituloMultimedia());
                publicidadDAO.updateImpacts(publicidad);
                break;
            }
            case 2: {
                PeliculaDAO peliculaDAO = new PeliculaDAO();
                Pelicula pelicula = new Pelicula();
                pelicula.setTituloPelicula(listaReproduccion.getTituloMultimedia());
                peliculaDAO.updateImpacts(pelicula);
                break;
            }
            case 3: 
            case 4: {
                CapituloDAO capituloDAO = new CapituloDAO();
                Capitulo capitulo = new Capitulo();
                capitulo.setTituloCapitulo(listaReproduccion.getTituloMultimedia());
                capituloDAO.updateImpacts(capitulo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteRow() {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "DELETE FROM lista_reproduccion ORDER BY id_lista_reproduccion LIMIT 1";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.executeUpdate();
            System.out.println("Se elimin\u00f3 correctamente el elemento de la ListaReproduccion");
            return;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            try {
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

