/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.IGeneroCancionDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.GeneroCancion;

public class GeneroCancionDAO
implements IGeneroCancionDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<GeneroCancion> listAll() {
        ArrayList<GeneroCancion> listaGenerosCancion = new ArrayList<GeneroCancion>();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM generos_cancion ORDER BY id_genero_cancion";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idGeneroCancion = this.rs.getInt("id_genero_cancion");
                String generoCancion = this.rs.getString("genero_cancion");
                String nombreCarpetaGeneroCancion = this.rs.getString("nombre_carpeta_genero_cancion");
                String nombrePortadaGeneroCancion = this.rs.getString("nombre_portada_genero_cancion");
                String locacionPortadaGeneroCancion = this.rs.getString("locacion_portada_genero_cancion");
                GeneroCancion generoCancion1 = new GeneroCancion(idGeneroCancion, generoCancion, nombreCarpetaGeneroCancion, nombrePortadaGeneroCancion, locacionPortadaGeneroCancion);
                listaGenerosCancion.add(generoCancion1);
            }
            System.out.println("Se listaron correctamente todos los GeneroCancion");
            return listaGenerosCancion;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaGenerosCancion;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GeneroCancion list(GeneroCancion generoCancion) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM generos_cancion WHERE id_genero_cancion = ? ORDER BY id_genero_cancion";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, generoCancion.getIdGeneroCancion());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idGeneroCancion = this.rs.getInt("id_genero_cancion");
                String generoCancion1 = this.rs.getString("genero_cancion");
                String nombreCarpetaGeneroCancion = this.rs.getString("nombre_carpeta_genero_cancion");
                String nombrePortadaGeneroCancion = this.rs.getString("nombre_portada_genero_cancion");
                String locacionPortadaGeneroCancion = this.rs.getString("locacion_portada_genero_cancion");
                generoCancion.setGeneroCancion(generoCancion1);
                generoCancion.setNombreCarpetaGeneroCancion(nombreCarpetaGeneroCancion);
                generoCancion.setNombrePortadaGeneroCancion(nombrePortadaGeneroCancion);
                generoCancion.setLocacionPortadaGeneroCancion(locacionPortadaGeneroCancion);
            }
            System.out.println("Se list\u00f3 correctamente el GeneroCancion");
            return generoCancion;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return generoCancion;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

