/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.IEstadoAutobusDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.EstadoAutobus;

public class EstadoAutobusDAO
implements IEstadoAutobusDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<EstadoAutobus> listAll() {
        ArrayList<EstadoAutobus> listaEstadosAutobus = new ArrayList<EstadoAutobus>();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM estados_autobus ORDER BY id_estado_autobus";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEstadoAutobus = this.rs.getInt("id_estado_autobus");
                String estadoAutobus = this.rs.getString("estado_autobus");
                EstadoAutobus estadoAutobus1 = new EstadoAutobus(idEstadoAutobus, estadoAutobus);
                listaEstadosAutobus.add(estadoAutobus1);
            }
            System.out.println("Se listaron correctamente todos los EstadoAutobus");
            return listaEstadosAutobus;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaEstadosAutobus;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EstadoAutobus list(EstadoAutobus estadoAutobus) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM estados_autobus WHERE id_estado_autobus = ? ORDER BY id_estado_autobus";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, estadoAutobus.getIdEstadoAutobus());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEstadoAutobus = this.rs.getInt("id_estado_autobus");
                String estadoAutobus1 = this.rs.getString("estado_autobus");
                estadoAutobus.setEstadoAutobus(estadoAutobus1);
            }
            System.out.println("Se list\u00f3 correctamente el EstadoAutobus");
            return estadoAutobus;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return estadoAutobus;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

