/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.IEmpleadoDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.MarcaDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.TipoEmpleadoDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.Empleado;
import mx.com.videoturismo.screensbuscontrolpanel.models.Marca;
import mx.com.videoturismo.screensbuscontrolpanel.models.TipoEmpleado;

public class EmpleadoDAO
implements IEmpleadoDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Empleado> listAll() {
        ArrayList<Empleado> listaEmpleados = new ArrayList<Empleado>();
        MarcaDAO marcaDAO = new MarcaDAO();
        TipoEmpleadoDAO tipoEmpleadoDAO = new TipoEmpleadoDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM empleados ORDER BY id_empleado";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEmpleado = this.rs.getInt("id_empleado");
                int idMarca = this.rs.getInt("id_marca");
                int idTipoEmpleado = this.rs.getInt("id_tipo_empleado");
                String nombreEmpleado = this.rs.getString("nombre_empleado");
                String apellidoPaternoEmpleado = this.rs.getString("apellido_paterno_empleado");
                String apellidoMaternoEmpleado = this.rs.getString("apellido_materno_empleado");
                String correo = this.rs.getString("correo");
                Date fechaAltaEmpleado = this.rs.getDate("fecha_alta_empleado");
                this.poolConnection.checkIn(this.cnn);
                Marca marca = marcaDAO.list(new Marca(idMarca));
                TipoEmpleado tipoEmpleado = tipoEmpleadoDAO.list(new TipoEmpleado(idTipoEmpleado));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Empleado empleado = new Empleado(idEmpleado, marca, tipoEmpleado, nombreEmpleado, apellidoPaternoEmpleado, apellidoMaternoEmpleado, correo, fechaAltaEmpleado);
                listaEmpleados.add(empleado);
            }
            System.out.println("Se listaron correctamente todas las Empleado");
            return listaEmpleados;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaEmpleados;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Empleado list(Empleado empleado) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        MarcaDAO marcaDAO = new MarcaDAO();
        TipoEmpleadoDAO tipoEmpleadoDAO = new TipoEmpleadoDAO();
        String sql = "SELECT * FROM empleados WHERE id_empleado = ? ORDER BY id_empleado";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, empleado.getIdEmpleado());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idEmpleado = this.rs.getInt("id_empleado");
                int idMarca = this.rs.getInt("id_marca");
                int idTipoEmpleado = this.rs.getInt("id_tipo_empleado");
                String nombreEmpleado = this.rs.getString("nombre_empleado");
                String apellidoPaternoEmpleado = this.rs.getString("apellido_paterno_empleado");
                String apellidoMaternoEmpleado = this.rs.getString("apellido_materno_empleado");
                String correo = this.rs.getString("correo");
                Date fechaAltaEmpleado = this.rs.getDate("fecha_alta_empleado");
                this.poolConnection.checkIn(this.cnn);
                Marca marca = marcaDAO.list(new Marca(idMarca));
                TipoEmpleado tipoEmpleado = tipoEmpleadoDAO.list(new TipoEmpleado(idTipoEmpleado));
                this.cnn = (Connection)this.poolConnection.checkOut();
                empleado.setMarca(marca);
                empleado.setTipoEmpleado(tipoEmpleado);
                empleado.setNombreEmpleado(nombreEmpleado);
                empleado.setApellidoPaternoEmpleado(apellidoPaternoEmpleado);
                empleado.setApellidoMaternoEmpleado(apellidoMaternoEmpleado);
                empleado.setCorreo(correo);
                empleado.setFechaAltaEmpleado(fechaAltaEmpleado);
            }
            System.out.println("Se list\u00f3 correctamente la Empleado");
            return empleado;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return empleado;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean comprobeEmployee(Empleado empleado) {
        boolean exists = false;
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM empleados WHERE id_empleado = ?";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, empleado.getIdEmpleado());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                exists = true;
            }
            System.out.println("Se comprob\u00f3 la existencia del Empleado");
            return exists;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return exists;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

