/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.ICapituloDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.SerieYDocumentalDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.Capitulo;
import mx.com.videoturismo.screensbuscontrolpanel.models.SerieYDocumental;

public class CapituloDAO
implements ICapituloDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Capitulo> listAll() {
        ArrayList<Capitulo> listaCapitulos = new ArrayList<Capitulo>();
        SerieYDocumentalDAO serieYDocumentalDAO = new SerieYDocumentalDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM capitulos ORDER BY id_capitulo";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idCapitulo = this.rs.getInt("id_capitulo");
                int idSerieYDocumental = this.rs.getInt("id_serie_y_documental");
                String tituloCapitulo = this.rs.getString("titulo_capitulo");
                String nombreArchivoCapitulo = this.rs.getString("nombre_archivo_capitulo");
                String nombrePortadaCapitulo = this.rs.getString("nombre_portada_capitulo");
                String locacionArchivoCapitulo = this.rs.getString("locacion_archivo_capitulo");
                String locacionPortadaCapitulo = this.rs.getString("locacion_portada_capitulo");
                String sinopsisCapitulo = this.rs.getString("sinopsis_capitulo");
                int duracionCapitulo = this.rs.getInt("duracion_capitulo");
                Date fechaAltaCapitulo = this.rs.getDate("fecha_alta_capitulo");
                int impactosCapitulo = this.rs.getInt("impactos_capitulo");
                int vistasCapitulo = this.rs.getInt("vistas_capitulo");
                SerieYDocumental serieYDocumental = serieYDocumentalDAO.list(new SerieYDocumental(idSerieYDocumental));
                Capitulo capitulo = new Capitulo(idCapitulo, serieYDocumental, tituloCapitulo, nombreArchivoCapitulo, nombrePortadaCapitulo, locacionArchivoCapitulo, locacionPortadaCapitulo, sinopsisCapitulo, duracionCapitulo, fechaAltaCapitulo, impactosCapitulo, vistasCapitulo);
                listaCapitulos.add(capitulo);
            }
            System.out.println("Se listaron correctamente todos los Capitulo");
            return listaCapitulos;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaCapitulos;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Capitulo list(Capitulo capitulo) {
        SerieYDocumentalDAO serieYDocumentalDAO = new SerieYDocumentalDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM capitulos WHERE id_capitulo = ? ORDER BY id_capitulo";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, capitulo.getIdCapitulo());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idCapitulo = this.rs.getInt("id_capitulo");
                int idSerieYDocumental = this.rs.getInt("id_serie_y_documental");
                String tituloCapitulo = this.rs.getString("titulo_capitulo");
                String nombreArchivoCapitulo = this.rs.getString("nombre_archivo_capitulo");
                String nombrePortadaCapitulo = this.rs.getString("nombre_portada_capitulo");
                String locacionArchivoCapitulo = this.rs.getString("locacion_archivo_capitulo");
                String locacionPortadaCapitulo = this.rs.getString("locacion_portada_capitulo");
                String sinopsisCapitulo = this.rs.getString("sinopsis_capitulo");
                int duracionCapitulo = this.rs.getInt("duracion_capitulo");
                Date fechaAltaCapitulo = this.rs.getDate("fecha_alta_capitulo");
                int impactosCapitulo = this.rs.getInt("impactos_capitulo");
                int vistasCapitulo = this.rs.getInt("vistas_capitulo");
                this.poolConnection.checkIn(this.cnn);
                SerieYDocumental serieYDocumental = serieYDocumentalDAO.list(new SerieYDocumental(idSerieYDocumental));
                this.cnn = (Connection)this.poolConnection.checkOut();
                capitulo.setSerieYDocumental(serieYDocumental);
                capitulo.setTituloCapitulo(tituloCapitulo);
                capitulo.setNombreArchivoCapitulo(nombreArchivoCapitulo);
                capitulo.setNombrePortadaCapitulo(nombrePortadaCapitulo);
                capitulo.setLocacionArchivoCapitulo(locacionArchivoCapitulo);
                capitulo.setLocacionPortadaCapitulo(locacionPortadaCapitulo);
                capitulo.setSinopsisCapitulo(sinopsisCapitulo);
                capitulo.setDuracionCapitulo(duracionCapitulo);
                capitulo.setImpactosCapitulo(impactosCapitulo);
                capitulo.setVistasCapitulo(vistasCapitulo);
            }
            System.out.println("Se list\u00f3 correctamente el Capitulo");
            return capitulo;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return capitulo;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Capitulo listByTitle(Capitulo capitulo) {
        SerieYDocumentalDAO serieYDocumentalDAO = new SerieYDocumentalDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM capitulos WHERE titulo_capitulo = ? ORDER BY id_capitulo";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setString(1, capitulo.getTituloCapitulo());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idCapitulo = this.rs.getInt("id_capitulo");
                int idSerieYDocumental = this.rs.getInt("id_serie_y_documental");
                String tituloCapitulo = this.rs.getString("titulo_capitulo");
                String nombreArchivoCapitulo = this.rs.getString("nombre_archivo_capitulo");
                String nombrePortadaCapitulo = this.rs.getString("nombre_portada_capitulo");
                String locacionArchivoCapitulo = this.rs.getString("locacion_archivo_capitulo");
                String locacionPortadaCapitulo = this.rs.getString("locacion_portada_capitulo");
                String sinopsisCapitulo = this.rs.getString("sinopsis_capitulo");
                int duracionCapitulo = this.rs.getInt("duracion_capitulo");
                Date fechaAltaCapitulo = this.rs.getDate("fecha_alta_capitulo");
                int impactosCapitulo = this.rs.getInt("impactos_capitulo");
                int vistasCapitulo = this.rs.getInt("vistas_capitulo");
                this.poolConnection.checkIn(this.cnn);
                SerieYDocumental serieYDocumental = serieYDocumentalDAO.list(new SerieYDocumental(idSerieYDocumental));
                this.cnn = (Connection)this.poolConnection.checkOut();
                capitulo.setIdCapitulo(idCapitulo);
                capitulo.setSerieYDocumental(serieYDocumental);
                capitulo.setTituloCapitulo(tituloCapitulo);
                capitulo.setNombreArchivoCapitulo(nombreArchivoCapitulo);
                capitulo.setNombrePortadaCapitulo(nombrePortadaCapitulo);
                capitulo.setLocacionArchivoCapitulo(locacionArchivoCapitulo);
                capitulo.setLocacionPortadaCapitulo(locacionPortadaCapitulo);
                capitulo.setSinopsisCapitulo(sinopsisCapitulo);
                capitulo.setDuracionCapitulo(duracionCapitulo);
                capitulo.setImpactosCapitulo(impactosCapitulo);
                capitulo.setVistasCapitulo(vistasCapitulo);
            }
            System.out.println("Se list\u00f3 correctamente el Capitulo");
            return capitulo;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return capitulo;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Capitulo updateImpacts(Capitulo capitulo) {
        capitulo = this.listByTitle(capitulo);
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "UPDATE capitulos SET impactos_capitulo = ? WHERE id_capitulo = ?";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, capitulo.getImpactosCapitulo() + 1);
            this.pst.setInt(2, capitulo.getIdCapitulo());
            this.pst.executeUpdate();
            System.out.println("Se agreg\u00f3 correctamente el impacto a la capitulo: " + capitulo.getTituloCapitulo());
            return capitulo;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return capitulo;
        }
        finally {
            try {
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

