/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseMenuUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class TextureMenuUI
extends BaseMenuUI {
    public TextureMenuUI() {
        this.paintRolloverBorder = false;
    }

    public static ComponentUI createUI(JComponent c) {
        return new TextureMenuUI();
    }

    protected void paintBackground(Graphics g, JComponent c, int x, int y, int w, int h) {
        JMenuItem mi = (JMenuItem)c;
        ButtonModel model = mi.getModel();
        if (c.getParent() instanceof JMenuBar) {
            if (model.isRollover() || model.isArmed() || c instanceof JMenu && model.isSelected()) {
                TextureUtils.fillComponent(g, c, 4);
            }
        } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
            TextureUtils.fillComponent(g, c, 4);
        } else if (!(mi.getBackground() instanceof ColorUIResource)) {
            super.paintBackground(g, c, x, y, w, h);
        } else {
            TextureUtils.fillComponent(g, c, 7);
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (!AbstractLookAndFeel.getTheme().isDarkTexture()) {
            super.paintText(g, menuItem, textRect, text);
            return;
        }
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(menuItem, g, menuItem.getFont());
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            g.setColor(Color.black);
            JTattooUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getDisabledForegroundColor(), 40.0));
        } else {
            g.setColor(AbstractLookAndFeel.getMenuForegroundColor());
            if (menuItem.getParent() instanceof JMenuBar) {
                if (model.isRollover() || model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                    g.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
                }
            } else if (menuItem.isArmed() || menuItem.isSelected()) {
                g.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
            } else {
                g.setColor(Color.black);
                JTattooUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
                Color foreColor = menuItem.getForeground();
                if (foreColor instanceof UIResource) {
                    foreColor = AbstractLookAndFeel.getMenuForegroundColor();
                }
                g.setColor(foreColor);
            }
        }
        JTattooUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }
}

