/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mx.com.videoturismo.screensbuscontrolpanel.daos.ServicioDAO;
import mx.com.videoturismo.screensbuscontrolpanel.functions.Language;
import mx.com.videoturismo.screensbuscontrolpanel.gui.Category1Services;
import mx.com.videoturismo.screensbuscontrolpanel.gui.Category2Services;
import mx.com.videoturismo.screensbuscontrolpanel.gui.Category3Services;
import mx.com.videoturismo.screensbuscontrolpanel.gui.Category4Services;
import mx.com.videoturismo.screensbuscontrolpanel.gui.Category5Services;
import mx.com.videoturismo.screensbuscontrolpanel.gui.Category6Services;
import mx.com.videoturismo.screensbuscontrolpanel.models.CategoriaServicio;

public class ServicePanel
extends JDialog {
    Language language = Language.getLocalLanguage();
    int catId1 = 1;
    int catId2 = 2;
    int catId3 = 3;
    int catId4 = 4;
    int catId5 = 5;
    int catId6 = 6;
    List<CategoriaServicio> categoriasServicio = new ArrayList<CategoriaServicio>();
    String cat1Img = "/Iconos_Servicios/Cleaning.png";
    String cat2Img = "/Iconos_Servicios/Treatment.png";
    String cat3Img = "/Iconos_Servicios/Tire.png";
    String cat4Img = "/Iconos_Servicios/Lights.png";
    String cat5Img = "/Iconos_Servicios/Security.png";
    String cat6Img = "/Iconos_Servicios/Air.png";
    String cat1ImgRed = "/Iconos_Servicios/CleaningRed.png";
    String cat2ImgRed = "/Iconos_Servicios/TreatmentRed.png";
    String cat3ImgRed = "/Iconos_Servicios/TireRed.png";
    String cat4ImgRed = "/Iconos_Servicios/LightsRed.png";
    String cat5ImgRed = "/Iconos_Servicios/SecurityRed.png";
    String cat6ImgRed = "/Iconos_Servicios/AirRed.png";
    ServicioDAO servicioDAO = new ServicioDAO();
    private JButton btnCat1;
    private JButton btnCat2;
    private JButton btnCat3;
    private JButton btnCat4;
    private JButton btnCat5;
    private JButton btnCat6;
    private JButton btnClose;
    private JLabel lblServicePanel;

    ServicePanel(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initializeCategoriasServicio();
        this.comprobeCategoriesColor();
    }

    private void initializeCategoriasServicio() {
        this.categoriasServicio.add(new CategoriaServicio(this.catId1));
        this.categoriasServicio.add(new CategoriaServicio(this.catId2));
        this.categoriasServicio.add(new CategoriaServicio(this.catId3));
        this.categoriasServicio.add(new CategoriaServicio(this.catId4));
        this.categoriasServicio.add(new CategoriaServicio(this.catId5));
        this.categoriasServicio.add(new CategoriaServicio(this.catId6));
    }

    private void setBackGroundColors(boolean playing) {
        if (playing) {
            this.getContentPane().setBackground(new Color(127, 0, 0));
        } else {
            this.getContentPane().setBackground(new Color(0, 96, 0));
        }
    }

    private void setBtnIcon(String img, JButton button) {
        ImageIcon icon = new ImageIcon(this.getClass().getResource(img));
        Image imgBtn = icon.getImage();
        Dimension prefSize = button.getPreferredSize();
        int width = (int)(prefSize.getWidth() * 0.6);
        int height = (int)(prefSize.getHeight() * 0.6);
        Image imgRedimBtn = imgBtn.getScaledInstance(width, height, 1);
        ImageIcon iconRedimBtn = new ImageIcon(imgRedimBtn);
        button.setIcon(iconRedimBtn);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
    }

    private void comprobeCategoriesColor() {
        int cont = 0;
        String img = "/Iconos/Next.png";
        JButton button = null;
        for (CategoriaServicio categoriaServicio : this.categoriasServicio) {
            switch (cont) {
                case 0: {
                    img = !this.servicioDAO.isCategoryReported(categoriaServicio) ? this.cat1Img : this.cat1ImgRed;
                    button = this.btnCat1;
                    break;
                }
                case 1: {
                    img = !this.servicioDAO.isCategoryReported(categoriaServicio) ? this.cat2Img : this.cat2ImgRed;
                    button = this.btnCat2;
                    break;
                }
                case 2: {
                    img = !this.servicioDAO.isCategoryReported(categoriaServicio) ? this.cat3Img : this.cat3ImgRed;
                    button = this.btnCat3;
                    break;
                }
                case 3: {
                    img = !this.servicioDAO.isCategoryReported(categoriaServicio) ? this.cat4Img : this.cat4ImgRed;
                    button = this.btnCat4;
                    break;
                }
                case 4: {
                    img = !this.servicioDAO.isCategoryReported(categoriaServicio) ? this.cat5Img : this.cat5ImgRed;
                    button = this.btnCat5;
                    break;
                }
                case 5: {
                    img = !this.servicioDAO.isCategoryReported(categoriaServicio) ? this.cat6Img : this.cat6ImgRed;
                    button = this.btnCat6;
                }
            }
            this.setBtnIcon(img, button);
            ++cont;
        }
    }

    private void openServices(int categoryNumber, int catId) {
        Window categoryServices = null;
        switch (categoryNumber) {
            case 1: {
                categoryServices = new Category1Services(null, true, catId);
                break;
            }
            case 2: {
                categoryServices = new Category2Services(null, true, catId);
                break;
            }
            case 3: {
                categoryServices = new Category3Services(null, true, catId);
                break;
            }
            case 4: {
                categoryServices = new Category4Services(null, true, catId);
                break;
            }
            case 5: {
                categoryServices = new Category5Services(null, true, catId);
                break;
            }
            case 6: {
                categoryServices = new Category6Services(null, true, catId);
            }
        }
        categoryServices.setLocationRelativeTo(this);
        ((Dialog)categoryServices).setVisible(true);
        this.comprobeCategoriesColor();
    }

    private void initComponents() {
        this.btnClose = new JButton();
        this.btnCat5 = new JButton();
        this.btnCat3 = new JButton();
        this.btnCat1 = new JButton();
        this.btnCat4 = new JButton();
        this.btnCat2 = new JButton();
        this.lblServicePanel = new JLabel();
        this.btnCat6 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Emergencia");
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 153, 0));
        this.setUndecorated(true);
        this.btnClose.setFont(new Font("Cantarell", 1, 24));
        this.btnClose.setText("Cerrar");
        this.btnClose.setText(this.language.getProperty("close"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicePanel.this.btnCloseActionPerformed(evt);
            }
        });
        this.btnCat5.setFont(new Font("Ubuntu", 1, 24));
        this.btnCat5.setPreferredSize(new Dimension(200, 200));
        this.btnCat5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicePanel.this.btnCat5ActionPerformed(evt);
            }
        });
        this.btnCat3.setFont(new Font("Tahoma", 1, 24));
        this.btnCat3.setPreferredSize(new Dimension(200, 200));
        this.btnCat3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicePanel.this.btnCat3ActionPerformed(evt);
            }
        });
        this.btnCat1.setFont(new Font("Tahoma", 1, 24));
        this.btnCat1.setPreferredSize(new Dimension(200, 200));
        this.btnCat1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicePanel.this.btnCat1ActionPerformed(evt);
            }
        });
        this.btnCat4.setFont(new Font("Tahoma", 1, 24));
        this.btnCat4.setPreferredSize(new Dimension(200, 200));
        this.btnCat4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicePanel.this.btnCat4ActionPerformed(evt);
            }
        });
        this.btnCat2.setFont(new Font("Tahoma", 1, 24));
        this.btnCat2.setPreferredSize(new Dimension(200, 200));
        this.btnCat2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicePanel.this.btnCat2ActionPerformed(evt);
            }
        });
        this.lblServicePanel.setFont(new Font("Tahoma", 1, 48));
        this.lblServicePanel.setHorizontalAlignment(0);
        this.lblServicePanel.setText("Panel de Servicios");
        this.lblServicePanel.setText(this.language.getProperty("lblServicePanel2"));
        this.btnCat6.setFont(new Font("Ubuntu", 1, 24));
        this.btnCat6.setPreferredSize(new Dimension(200, 200));
        this.btnCat6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicePanel.this.btnCat6ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblServicePanel, -1, -1, Short.MAX_VALUE).addComponent(this.btnClose, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnCat1, -1, 220, Short.MAX_VALUE).addComponent(this.btnCat4, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnCat5, -2, 220, -2).addGap(18, 18, 18).addComponent(this.btnCat6, -2, 220, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnCat2, -2, 220, -2).addGap(18, 18, 18).addComponent(this.btnCat3, -2, 220, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblServicePanel, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnCat2, -1, -1, Short.MAX_VALUE).addComponent(this.btnCat3, -1, -1, Short.MAX_VALUE).addComponent(this.btnCat1, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnCat5, -1, -1, Short.MAX_VALUE).addComponent(this.btnCat6, -1, -1, Short.MAX_VALUE).addComponent(this.btnCat4, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.btnClose, -1, 99, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnCat1ActionPerformed(ActionEvent evt) {
        this.openServices(1, this.catId1);
    }

    private void btnCat2ActionPerformed(ActionEvent evt) {
        this.openServices(2, this.catId2);
    }

    private void btnCat3ActionPerformed(ActionEvent evt) {
        this.openServices(3, this.catId3);
    }

    private void btnCat4ActionPerformed(ActionEvent evt) {
        this.openServices(4, this.catId4);
    }

    private void btnCat5ActionPerformed(ActionEvent evt) {
        this.openServices(5, this.catId5);
    }

    private void btnCat6ActionPerformed(ActionEvent evt) {
        this.openServices(6, this.catId6);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ServicePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ServicePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ServicePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ServicePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServicePanel dialog = new ServicePanel((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

