/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.gui;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mx.com.videoturismo.screensbuscontrolpanel.daos.ListaReproduccionDAO;
import mx.com.videoturismo.screensbuscontrolpanel.functions.Language;
import mx.com.videoturismo.screensbuscontrolpanel.gui.ConfirmDialog;
import mx.com.videoturismo.screensbuscontrolpanel.gui.EmergencyWindow;
import mx.com.videoturismo.screensbuscontrolpanel.gui.Main;
import mx.com.videoturismo.screensbuscontrolpanel.models.ListaReproduccion;
import mx.com.videoturismo.screensbuscontrolpanel.models.Ruta;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.x.XFullScreenStrategy;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.runtime.x.LibXUtil;

public class PlayWindow
extends JFrame {
    Language language = Language.getLocalLanguage();
    String btnBackImg = "/Iconos/Back.png";
    String btnSkipImg = "/Iconos/Skip.png";
    String btnPlayImg = "/Iconos/Play.png";
    String btnPauseImg = "/Iconos/Pause.png";
    String btnVolDownImg = "/Iconos/VolumeDown.png";
    String btnVolUPImg = "/Iconos/VolumeUP.png";
    String btnEmergencyImg = "/Iconos/Emergency.png";
    String btnShutdownImg = "/Iconos/ShutDown.png";
    ListaReproduccionDAO listaReproduccionDAO = new ListaReproduccionDAO();
    File lastTime = new File("/home/autobus/Documentos/tmp/tiempo.txt");
    List<ListaReproduccion> mediaListt = this.listaReproduccionDAO.listAll();
    int size = this.mediaListt.size();
    int cont = 0;
    boolean flag = false;
    JFrame jFrame = null;
    EmbeddedMediaPlayer embeddedMediaPlayer = null;
    boolean pause = false;
    Ruta ruta;
    int contBack = 0;
    private JButton btnBack;
    private JButton btnEmergency;
    private JButton btnPause;
    private JButton btnPlay;
    private JButton btnShutdown;
    private JButton btnSkip;
    private JButton btnVolDown;
    private JButton btnVolUp;
    private JLabel lblMediaPlaying;
    private JLabel lblPlaying;
    private JLabel lblRoute;
    private JLabel lblVolume;
    private JLabel lblVolumeLevel;

    public PlayWindow(Ruta ruta) {
        this.initComponents();
        this.setExtendedState(6);
        this.setSize(1024, 768);
        LibXUtil.initialise();
        this.lblRoute.setText(this.language.getProperty("route") + ": " + ruta.getOrigen() + " - " + ruta.getDestino());
        this.lblPlaying.setText(this.language.getProperty("playing"));
        this.lblMediaPlaying.setText(this.language.getProperty("noMedia"));
        this.setTitle(this.language.getProperty("playingTitle"));
        this.setBackGroundColors(false);
        this.ruta = ruta;
        this.toBack();
        this.requestFocus();
    }

    public void setBackGroundColors(boolean playing) {
        if (playing) {
            this.getContentPane().setBackground(new Color(0, 96, 0));
        } else {
            this.getContentPane().setBackground(new Color(127, 0, 0));
        }
    }

    public void setPauseButton(boolean paused) {
        ImageIcon iconPauseBtn = paused ? new ImageIcon(this.getClass().getResource("/Iconos/Play.png")) : new ImageIcon(this.getClass().getResource("/Iconos/Pause.png"));
        Image imgBtnPause = iconPauseBtn.getImage();
        Dimension prefSizePause = this.btnPause.getPreferredSize();
        int widthPause = (int)(prefSizePause.getWidth() * 0.6);
        int heightPause = (int)(prefSizePause.getHeight() * 0.6);
        Image imgRedimBtnPause = imgBtnPause.getScaledInstance(widthPause, heightPause, 1);
        ImageIcon iconRedimBtnPause = new ImageIcon(imgRedimBtnPause);
        this.btnPause.setIcon(iconRedimBtnPause);
        this.btnPause.setOpaque(false);
        this.btnPause.setContentAreaFilled(false);
        this.btnPause.setBorderPainted(false);
    }

    public void initializeVideo() {
        NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcLibraryName(), (String)"/usr/lib/x86_64-linux-gnu");
        System.setProperty("VLC_PLUGIN_PATH", "/usr/lib/x86_64-linux-gnu/libvlc.so.5.6.0");
        Native.loadLibrary((String)RuntimeUtil.getLibVlcLibraryName(), LibVlc.class);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Canvas c = new Canvas();
        for (int j = 1; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < 1; ++i) {
                this.jFrame = new JFrame();
                Rectangle gcBounds = gc[i].getBounds();
                int xoffs = gcBounds.x;
                int yoffs = gcBounds.y;
                System.out.println(xoffs);
                System.out.println(yoffs);
                this.jFrame.setLocation(i * 50 + xoffs, i * 60 + yoffs);
                this.jFrame.setSize(1000, 600);
                this.jFrame.setAlwaysOnTop(true);
                this.jFrame.setDefaultCloseOperation(3);
                this.jFrame.setUndecorated(true);
                this.jFrame.setVisible(true);
                this.jFrame.toFront();
                JPanel p = new JPanel();
                c = new Canvas();
                c.setBackground(Color.black);
                p.setLayout(new BorderLayout());
                p.add(c);
                this.jFrame.add(p);
            }
        }
        MediaPlayerFactory mediaPlayerFactory = new MediaPlayerFactory();
        this.embeddedMediaPlayer = mediaPlayerFactory.newEmbeddedMediaPlayer((FullScreenStrategy)new XFullScreenStrategy((Window)this.jFrame));
        this.embeddedMediaPlayer.setVideoSurface(mediaPlayerFactory.newVideoSurface(c));
        LibXUtil.setFullScreenWindow((Window)this.jFrame, (boolean)true);
        this.embeddedMediaPlayer.toggleFullScreen();
        this.embeddedMediaPlayer.setEnableMouseInputHandling(false);
        this.embeddedMediaPlayer.setEnableKeyInputHandling(false);
        this.reproduceVideo();
        if (this.lastTime.exists()) {
            String line = "";
            long milliseconds = 0L;
            try {
                BufferedReader in = new BufferedReader(new FileReader("/home/autobus/Documentos/tmp/tiempo.txt"));
                while ((line = in.readLine()) != null) {
                    milliseconds = Long.parseLong(line);
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.embeddedMediaPlayer.setTime(milliseconds);
        }
    }

    public void reproduceVideo() {
        ListaReproduccion listaReproduccion = this.mediaListt.get(this.cont);
        String mediaRoute = listaReproduccion.getRutaMultimedia();
        int duration = listaReproduccion.getDuracionMultimedia();
        String type = listaReproduccion.getTipoMultimedia().getTipoMultimedia();
        String title = listaReproduccion.getTituloMultimedia();
        if (this.cont == 1) {
            this.lblPlaying.setText(this.language.getProperty("playing"));
        }
        switch (type) {
            case "Publicidad": {
                this.lblMediaPlaying.setText(this.language.getProperty("advertising") + ": " + title);
                break;
            }
            case "Pelicula": {
                this.lblMediaPlaying.setText(this.language.getProperty("movie") + ": " + title);
                break;
            }
            case "Serie": {
                this.lblMediaPlaying.setText(this.language.getProperty("series") + ": " + title);
                break;
            }
            case "Documental": {
                this.lblMediaPlaying.setText(this.language.getProperty("documentary") + ": " + title);
            }
        }
        this.listaReproduccionDAO.addImpacto(listaReproduccion);
        this.embeddedMediaPlayer.playMedia(mediaRoute, new String[0]);
        ++this.cont;
        this.toBack();
        this.requestFocus();
    }

    public void skipVideo() {
        this.embeddedMediaPlayer.addMediaPlayerEventListener((MediaPlayerEventListener)new MediaPlayerEventAdapter(){

            public void finished(MediaPlayer mediaPlayer) {
                if (PlayWindow.this.cont < PlayWindow.this.size) {
                    PlayWindow.this.reproduceVideo();
                    PlayWindow.this.listaReproduccionDAO.deleteRow();
                } else {
                    PlayWindow.this.lblPlaying.setText(PlayWindow.this.language.getProperty("finished"));
                    PlayWindow.this.lblMediaPlaying.setText("");
                }
            }
        });
    }

    @Override
    public Image getIconImage() {
        Image retValue = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Iconos/logo.png"));
        return retValue;
    }

    private void initComponents() {
        this.btnBack = new JButton();
        this.btnSkip = new JButton();
        this.btnPlay = new JButton();
        this.btnVolUp = new JButton();
        this.btnVolDown = new JButton();
        this.lblRoute = new JLabel();
        this.lblPlaying = new JLabel();
        this.lblMediaPlaying = new JLabel();
        this.btnPause = new JButton();
        this.lblVolume = new JLabel();
        this.lblVolumeLevel = new JLabel();
        this.btnEmergency = new JButton();
        this.btnShutdown = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Reproducir multimedia");
        this.setIconImage(this.getIconImage());
        this.setUndecorated(true);
        this.setResizable(false);
        this.btnBack.setFont(new Font("Tahoma", 1, 24));
        this.btnBack.setPreferredSize(new Dimension(200, 200));
        ImageIcon iconBackBtn = new ImageIcon(this.getClass().getResource(this.btnBackImg));
        Image imgBtnBack = iconBackBtn.getImage();
        Dimension prefSizeBack = this.btnBack.getPreferredSize();
        int widthBack = (int)(prefSizeBack.getWidth() * 0.6);
        int heightBack = (int)(prefSizeBack.getHeight() * 0.6);
        Image imgRedimBtnBack = imgBtnBack.getScaledInstance(widthBack, heightBack, 1);
        ImageIcon iconRedimBtnBack = new ImageIcon(imgRedimBtnBack);
        this.btnBack.setIcon(iconRedimBtnBack);
        this.btnBack.setOpaque(false);
        this.btnBack.setContentAreaFilled(false);
        this.btnBack.setBorderPainted(false);
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayWindow.this.btnBackActionPerformed(evt);
            }
        });
        this.btnSkip.setFont(new Font("Tahoma", 1, 24));
        this.btnSkip.setEnabled(false);
        this.btnSkip.setPreferredSize(new Dimension(200, 200));
        ImageIcon iconSkipBtn = new ImageIcon(this.getClass().getResource(this.btnSkipImg));
        Image imgBtnSkip = iconSkipBtn.getImage();
        Dimension prefSizeSkip = this.btnSkip.getPreferredSize();
        int widthSkip = (int)(prefSizeSkip.getWidth() * 0.6);
        int heightSkip = (int)(prefSizeSkip.getHeight() * 0.6);
        Image imgRedimBtnSkip = imgBtnSkip.getScaledInstance(widthSkip, heightSkip, 1);
        ImageIcon iconRedimBtnSkip = new ImageIcon(imgRedimBtnSkip);
        this.btnSkip.setIcon(iconRedimBtnSkip);
        this.btnSkip.setOpaque(false);
        this.btnSkip.setContentAreaFilled(false);
        this.btnSkip.setBorderPainted(false);
        this.btnSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayWindow.this.btnSkipActionPerformed(evt);
            }
        });
        this.btnPlay.setFont(new Font("Tahoma", 1, 24));
        this.btnPlay.setPreferredSize(new Dimension(200, 200));
        ImageIcon iconPlayBtn = new ImageIcon(this.getClass().getResource(this.btnPlayImg));
        Image imgBtnPlay = iconPlayBtn.getImage();
        Dimension prefSizePlay = this.btnPlay.getPreferredSize();
        int widthPlay = (int)(prefSizePlay.getWidth() * 0.6);
        int heightPlay = (int)(prefSizePlay.getHeight() * 0.6);
        Image imgRedimBtnPlay = imgBtnPlay.getScaledInstance(widthPlay, heightPlay, 1);
        ImageIcon iconRedimBtnPlay = new ImageIcon(imgRedimBtnPlay);
        this.btnPlay.setIcon(iconRedimBtnPlay);
        this.btnPlay.setOpaque(false);
        this.btnPlay.setContentAreaFilled(false);
        this.btnPlay.setBorderPainted(false);
        this.btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayWindow.this.btnPlayActionPerformed(evt);
            }
        });
        this.btnVolUp.setFont(new Font("Tahoma", 1, 48));
        this.btnVolUp.setEnabled(false);
        this.btnVolUp.setPreferredSize(new Dimension(200, 200));
        ImageIcon iconVolUpBtn = new ImageIcon(this.getClass().getResource(this.btnVolUPImg));
        Image imgBtnVolUp = iconVolUpBtn.getImage();
        Dimension prefSizeVolUp = this.btnVolUp.getPreferredSize();
        int widthVolUp = (int)(prefSizeVolUp.getWidth() * 0.6);
        int heightVolUp = (int)(prefSizeVolUp.getHeight() * 0.6);
        Image imgRedimBtnVolUp = imgBtnVolUp.getScaledInstance(widthVolUp, heightVolUp, 1);
        ImageIcon iconRedimBtnVolUp = new ImageIcon(imgRedimBtnVolUp);
        this.btnVolUp.setIcon(iconRedimBtnVolUp);
        this.btnVolUp.setOpaque(false);
        this.btnVolUp.setContentAreaFilled(false);
        this.btnVolUp.setBorderPainted(false);
        this.btnVolUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayWindow.this.btnVolUpActionPerformed(evt);
            }
        });
        this.btnVolDown.setFont(new Font("Tahoma", 1, 48));
        this.btnVolDown.setEnabled(false);
        this.btnVolDown.setPreferredSize(new Dimension(200, 200));
        ImageIcon iconVolDownBtn = new ImageIcon(this.getClass().getResource(this.btnVolDownImg));
        Image imgBtnVolDown = iconVolDownBtn.getImage();
        Dimension prefSizeVolDown = this.btnVolDown.getPreferredSize();
        int widthVolDown = (int)(prefSizeVolDown.getWidth() * 0.6);
        int heightVolDown = (int)(prefSizeVolDown.getHeight() * 0.6);
        Image imgRedimBtnVolDown = imgBtnVolDown.getScaledInstance(widthVolDown, heightVolDown, 1);
        ImageIcon iconRedimBtnVolDown = new ImageIcon(imgRedimBtnVolDown);
        this.btnVolDown.setIcon(iconRedimBtnVolDown);
        this.btnVolDown.setOpaque(false);
        this.btnVolDown.setContentAreaFilled(false);
        this.btnVolDown.setBorderPainted(false);
        this.btnVolDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayWindow.this.btnVolDownActionPerformed(evt);
            }
        });
        this.lblRoute.setFont(new Font("Tahoma", 1, 36));
        this.lblRoute.setText("Ruta: Chihuahua - Parral");
        this.lblPlaying.setFont(new Font("Tahoma", 1, 36));
        this.lblPlaying.setText("Reproduciendo");
        this.lblMediaPlaying.setFont(new Font("Tahoma", 1, 24));
        this.lblMediaPlaying.setText("Pelicula: Guardianes de la galaxia Vol 2");
        this.btnPause.setFont(new Font("Tahoma", 1, 24));
        this.btnPause.setEnabled(false);
        this.btnPause.setPreferredSize(new Dimension(200, 200));
        ImageIcon iconPauseBtn = new ImageIcon(this.getClass().getResource("/Iconos/Pause.png"));
        Image imgBtnPause = iconPauseBtn.getImage();
        Dimension prefSizePause = this.btnPause.getPreferredSize();
        int widthPause = (int)(prefSizePause.getWidth() * 0.6);
        int heightPause = (int)(prefSizePause.getHeight() * 0.6);
        Image imgRedimBtnPause = imgBtnPause.getScaledInstance(widthPause, heightPause, 1);
        ImageIcon iconRedimBtnPause = new ImageIcon(imgRedimBtnPause);
        this.btnPause.setIcon(iconRedimBtnPause);
        this.btnPause.setOpaque(false);
        this.btnPause.setContentAreaFilled(false);
        this.btnPause.setBorderPainted(false);
        this.btnPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayWindow.this.btnPauseActionPerformed(evt);
            }
        });
        this.lblVolume.setBackground(new Color(255, 255, 255));
        this.lblVolume.setFont(new Font("Tahoma", 1, 24));
        this.lblVolume.setForeground(new Color(255, 255, 255));
        this.lblVolume.setText("Vol.");
        this.lblVolumeLevel.setFont(new Font("Tahoma", 1, 24));
        this.lblVolumeLevel.setForeground(new Color(255, 255, 255));
        this.lblVolumeLevel.setText("100");
        this.btnEmergency.setFont(new Font("Tahoma", 1, 24));
        this.btnEmergency.setPreferredSize(new Dimension(200, 200));
        ImageIcon iconEmergencyBtn = new ImageIcon(this.getClass().getResource(this.btnEmergencyImg));
        Image imgBtnEmergency = iconEmergencyBtn.getImage();
        Dimension prefSizeEmergency = this.btnEmergency.getPreferredSize();
        int widthEmergency = (int)(prefSizeEmergency.getWidth() * 0.6);
        int heightEmergency = (int)(prefSizeEmergency.getHeight() * 0.6);
        Image imgRedimBtnEmergency = imgBtnEmergency.getScaledInstance(widthEmergency, heightEmergency, 1);
        ImageIcon iconRedimBtnEmergency = new ImageIcon(imgRedimBtnEmergency);
        this.btnEmergency.setIcon(iconRedimBtnEmergency);
        this.btnEmergency.setOpaque(false);
        this.btnEmergency.setContentAreaFilled(false);
        this.btnEmergency.setBorderPainted(false);
        this.btnEmergency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayWindow.this.btnEmergencyActionPerformed(evt);
            }
        });
        this.btnShutdown.setFont(new Font("Tahoma", 1, 18));
        this.btnShutdown.setPreferredSize(new Dimension(200, 200));
        ImageIcon iconShutdownBtn = new ImageIcon(this.getClass().getResource(this.btnShutdownImg));
        Image imgBtnShutdown = iconShutdownBtn.getImage();
        Dimension prefSizeShutdown = this.btnShutdown.getPreferredSize();
        int widthShutdown = (int)(prefSizeShutdown.getWidth() * 0.6);
        int heightShutdown = (int)(prefSizeShutdown.getHeight() * 0.6);
        Image imgRedimBtnShutdown = imgBtnShutdown.getScaledInstance(widthShutdown, heightShutdown, 1);
        ImageIcon iconRedimBtnShutdown = new ImageIcon(imgRedimBtnShutdown);
        this.btnShutdown.setIcon(iconRedimBtnShutdown);
        this.btnShutdown.setOpaque(false);
        this.btnShutdown.setContentAreaFilled(false);
        this.btnShutdown.setBorderPainted(false);
        this.btnShutdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayWindow.this.btnShutdownActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRoute).addComponent(this.lblPlaying).addComponent(this.lblMediaPlaying).addGroup(layout.createSequentialGroup().addComponent(this.btnBack, -2, -1, -2).addGap(18, 18, 18).addComponent(this.btnSkip, -2, 189, -2).addGap(18, 18, 18).addComponent(this.btnPlay, -2, 187, -2).addGap(18, 18, 18).addComponent(this.btnPause, -2, 180, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.lblVolume).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblVolumeLevel)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnVolUp, -1, 174, Short.MAX_VALUE).addComponent(this.btnEmergency, -2, 0, Short.MAX_VALUE).addComponent(this.btnVolDown, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.btnShutdown, -2, 174, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.lblRoute).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPlaying).addGap(18, 18, 18).addComponent(this.lblMediaPlaying).addGap(50, 50, 50)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.btnShutdown, -2, 150, -2).addGap(18, 18, 18))).addComponent(this.btnEmergency, -2, 154, -2).addGap(18, 18, 18).addComponent(this.btnVolUp, -2, 154, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblVolume).addComponent(this.lblVolumeLevel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSkip, -2, 154, -2).addComponent(this.btnBack, -2, 154, -2).addComponent(this.btnPlay, -2, 154, -2).addComponent(this.btnPause, -2, 154, -2)).addComponent(this.btnVolDown, -2, 154, -2)).addGap(30, 30, 30)));
        this.pack();
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        if (this.contBack == 0) {
            ++this.contBack;
            Main main = new Main();
            main.setVisible(true);
            try {
                if (this.embeddedMediaPlayer != null) {
                    ProcessBuilder processBuilder = new ProcessBuilder("/home/autobus/Software/Scripts/GuardarTiempoYRuta/GuardarTiempoYRuta.sh", Long.toString(this.embeddedMediaPlayer.getTime()), Integer.toString(this.ruta.getIdRuta()));
                    Process process = processBuilder.start();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (this.jFrame != null) {
                this.embeddedMediaPlayer.stop();
                this.jFrame.dispose();
            }
            this.dispose();
        }
    }

    private void btnPlayActionPerformed(ActionEvent evt) {
        this.btnPlay.setEnabled(false);
        this.btnSkip.setEnabled(true);
        this.btnVolDown.setEnabled(true);
        this.btnVolUp.setEnabled(true);
        this.btnPause.setEnabled(true);
        this.initializeVideo();
        this.skipVideo();
        this.setBackGroundColors(true);
    }

    private void btnPauseActionPerformed(ActionEvent evt) {
        if (this.pause) {
            this.embeddedMediaPlayer.setPause(false);
            this.pause = false;
            this.setBackGroundColors(true);
        } else {
            this.embeddedMediaPlayer.setPause(true);
            this.pause = true;
            this.setBackGroundColors(false);
        }
        this.setPauseButton(this.pause);
    }

    private void btnVolUpActionPerformed(ActionEvent evt) {
        if (this.embeddedMediaPlayer.getVolume() < 150) {
            this.embeddedMediaPlayer.setVolume(this.embeddedMediaPlayer.getVolume() + 10);
            this.lblVolumeLevel.setText(String.valueOf(this.embeddedMediaPlayer.getVolume() + 10));
        }
    }

    private void btnVolDownActionPerformed(ActionEvent evt) {
        if (this.embeddedMediaPlayer.getVolume() > 0) {
            this.embeddedMediaPlayer.setVolume(this.embeddedMediaPlayer.getVolume() - 10);
            this.lblVolumeLevel.setText(String.valueOf(this.embeddedMediaPlayer.getVolume() - 10));
        }
    }

    private void btnSkipActionPerformed(ActionEvent evt) {
        if (this.cont < this.size) {
            this.reproduceVideo();
            this.listaReproduccionDAO.deleteRow();
        }
    }

    private void btnEmergencyActionPerformed(ActionEvent evt) {
        this.btnEmergency.setEnabled(false);
        if (this.jFrame != null) {
            this.embeddedMediaPlayer.setPause(true);
            this.pause = true;
            this.jFrame.setVisible(false);
            this.setBackGroundColors(false);
        }
        EmergencyWindow emergency = new EmergencyWindow(null, true);
        emergency.setLocationRelativeTo(this);
        emergency.setVisible(true);
        this.btnEmergency.setEnabled(true);
        if (this.jFrame != null && this.pause) {
            this.embeddedMediaPlayer.setPause(false);
            this.pause = false;
            this.jFrame.setVisible(true);
            this.setBackGroundColors(true);
        }
    }

    private void btnShutdownActionPerformed(ActionEvent evt) {
        ConfirmDialog confirmDialog = new ConfirmDialog((Frame)this, true, this.language.getProperty("turnOffSystem"));
        confirmDialog.setLocationRelativeTo(this);
        boolean opc = confirmDialog.showDialog();
        if (opc) {
            try {
                if (this.embeddedMediaPlayer != null) {
                    ProcessBuilder processBuilder = new ProcessBuilder("/home/autobus/Software/Scripts/GuardarTiempoYRuta/GuardarTiempoYRuta.sh", Long.toString(this.embeddedMediaPlayer.getTime()), Integer.toString(this.ruta.getIdRuta()));
                    Process process = processBuilder.start();
                }
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("shutdown -h now");
                System.exit(0);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PlayWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PlayWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PlayWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PlayWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PlayWindow(null).setVisible(true);
            }
        });
    }
}

