/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.ILibroDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.Libro;

public class LibroDAO
implements ILibroDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Libro> listAll() {
        ArrayList<Libro> listaLibros = new ArrayList<Libro>();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM libros ORDER BY id_libro";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idLibro = this.rs.getInt("id_libro");
                String tituloLibro = this.rs.getString("titulo_libro");
                String nombreArchivoLibro = this.rs.getString("nombre_archivo_libro");
                String nombrePortadaLibro = this.rs.getString("nombre_portada_libro");
                String locacionArchivoLibro = this.rs.getString("locacion_archivo_libro");
                String locacionPortadaLibro = this.rs.getString("locacion_portada_libro");
                String sinopsisLibro = this.rs.getString("sinopsis_libro");
                Date fechaAltaLibro = this.rs.getDate("fecha_alta_libro");
                Date fechaInicioLibro = this.rs.getDate("fecha_inicio_libro");
                Date fechaFinLibro = this.rs.getDate("fecha_fin_libro");
                int impactosLibro = this.rs.getInt("impactos_libro");
                int vistasLibro = this.rs.getInt("vistas_libro");
                Libro libro = new Libro(idLibro, tituloLibro, nombreArchivoLibro, nombrePortadaLibro, locacionArchivoLibro, locacionPortadaLibro, sinopsisLibro, fechaAltaLibro, fechaInicioLibro, fechaFinLibro, impactosLibro, vistasLibro);
                listaLibros.add(libro);
            }
            System.out.println("Se listaron correctamente todos los Libro");
            return listaLibros;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaLibros;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Libro list(Libro libro) {
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM libros WHERE id_libro = ? ORDER BY id_libro";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, libro.getIdLibro());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idLibro = this.rs.getInt("id_libro");
                String tituloLibro = this.rs.getString("titulo_libro");
                String nombreArchivoLibro = this.rs.getString("nombre_archivo_libro");
                String nombrePortadaLibro = this.rs.getString("nombre_portada_libro");
                String locacionArchivoLibro = this.rs.getString("locacion_archivo_libro");
                String locacionPortadaLibro = this.rs.getString("locacion_portada_libro");
                String sinopsisLibro = this.rs.getString("sinopsis_libro");
                Date fechaAltaLibro = this.rs.getDate("fecha_alta_libro");
                Date fechaInicioLibro = this.rs.getDate("fecha_inicio_libro");
                Date fechaFinLibro = this.rs.getDate("fecha_fin_libro");
                int impactosLibro = this.rs.getInt("impactos_libro");
                int vistasLibro = this.rs.getInt("vistas_libro");
                libro.setTituloLibro(tituloLibro);
                libro.setNombreArchivoLibro(nombreArchivoLibro);
                libro.setNombrePortadaLibro(nombrePortadaLibro);
                libro.setLocacionArchivoLibro(locacionArchivoLibro);
                libro.setLocacionPortadaLibro(locacionPortadaLibro);
                libro.setSinopsisLibro(sinopsisLibro);
                libro.setFechaAltaLibro(fechaAltaLibro);
                libro.setFechaInicioLibro(fechaInicioLibro);
                libro.setFechaFinLibro(fechaFinLibro);
                libro.setImpactosLibro(impactosLibro);
                libro.setVistasLibro(vistasLibro);
            }
            System.out.println("Se list\u00f3 correctamente el Libro");
            return libro;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return libro;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

