/*
 * Decompiled with CFR 0.152.
 */
package mx.com.videoturismo.screensbuscontrolpanel.daos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mx.com.videoturismo.screensbuscontrolpanel.connections.DBConnection;
import mx.com.videoturismo.screensbuscontrolpanel.connections.PoolConnection;
import mx.com.videoturismo.screensbuscontrolpanel.daos.GeneroCancionDAO;
import mx.com.videoturismo.screensbuscontrolpanel.daos.ICancionDAO;
import mx.com.videoturismo.screensbuscontrolpanel.models.Cancion;
import mx.com.videoturismo.screensbuscontrolpanel.models.GeneroCancion;

public class CancionDAO
implements ICancionDAO {
    Connection cnn = null;
    PoolConnection poolConnection = DBConnection.returnConnectionPool();
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Cancion> listAll() {
        ArrayList<Cancion> listaCanciones = new ArrayList<Cancion>();
        GeneroCancionDAO generoCancionDAO = new GeneroCancionDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM canciones ORDER BY id_cancion";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idCancion = this.rs.getInt("id_cancion");
                int idGeneroCancion = this.rs.getInt("id_genero_cancion");
                String tituloCancion = this.rs.getString("titulo_cancion");
                String artista = this.rs.getString("artista");
                String album = this.rs.getString("album");
                String nombreArchivoCancion = this.rs.getString("nombre_archivo_cancion");
                String locacionArchivoCancion = this.rs.getString("locacion_archivo_cancion");
                Date fechaAltaCancion = this.rs.getDate("fecha_alta_cancion");
                Date fechaInicioCancion = this.rs.getDate("fecha_inicio_cancion");
                Date fechaFinCancion = this.rs.getDate("fecha_fin_cancion");
                int impactosCancion = this.rs.getInt("impactos_cancion");
                int vistasCancion = this.rs.getInt("vistas_cancion");
                this.poolConnection.checkIn(this.cnn);
                GeneroCancion generoCancion = generoCancionDAO.list(new GeneroCancion(idGeneroCancion));
                this.cnn = (Connection)this.poolConnection.checkOut();
                Cancion cancion = new Cancion(idCancion, generoCancion, tituloCancion, artista, album, nombreArchivoCancion, locacionArchivoCancion, fechaAltaCancion, fechaInicioCancion, fechaFinCancion, impactosCancion, vistasCancion);
                listaCanciones.add(cancion);
            }
            System.out.println("Se listaron correctamente todos las Cancion");
            return listaCanciones;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return listaCanciones;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cancion list(Cancion cancion) {
        GeneroCancionDAO generoCancionDAO = new GeneroCancionDAO();
        this.cnn = (Connection)this.poolConnection.checkOut();
        String sql = "SELECT * FROM canciones WHERE id_cancion = ? ORDER BY id_cancion";
        try {
            this.pst = this.cnn.prepareStatement(sql);
            this.pst.setInt(1, cancion.getIdCancion());
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                int idCancion = this.rs.getInt("id_cancion");
                int idGeneroCancion = this.rs.getInt("id_genero_cancion");
                String tituloCancion = this.rs.getString("titulo_cancion");
                String artista = this.rs.getString("artista");
                String album = this.rs.getString("album");
                String nombreArchivoCancion = this.rs.getString("nombre_archivo_cancion");
                String locacionArchivoCancion = this.rs.getString("locacion_archivo_cancion");
                Date fechaAltaCancion = this.rs.getDate("fecha_alta_cancion");
                Date fechaInicioCancion = this.rs.getDate("fecha_inicio_cancion");
                Date fechaFinCancion = this.rs.getDate("fecha_fin_cancion");
                int impactosCancion = this.rs.getInt("impactos_cancion");
                int vistasCancion = this.rs.getInt("vistas_cancion");
                this.poolConnection.checkIn(this.cnn);
                GeneroCancion generoCancion = generoCancionDAO.list(new GeneroCancion(idGeneroCancion));
                this.cnn = (Connection)this.poolConnection.checkOut();
                cancion.setGeneroCancion(generoCancion);
                cancion.setTituloCancion(tituloCancion);
                cancion.setArtista(artista);
                cancion.setAlbum(album);
                cancion.setNombreArchivoCancion(nombreArchivoCancion);
                cancion.setLocacionArchivoCancion(locacionArchivoCancion);
                cancion.setFechaAltaCancion(fechaAltaCancion);
                cancion.setFechaInicioCancion(fechaInicioCancion);
                cancion.setFechaFinCancion(fechaFinCancion);
                cancion.setImpactosCancion(impactosCancion);
                cancion.setVistasCancion(vistasCancion);
            }
            System.out.println("Se list\u00f3 correctamente la Cancion");
            return cancion;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return cancion;
        }
        finally {
            try {
                if (!this.rs.isClosed()) {
                    this.rs.close();
                }
                if (!this.pst.isClosed()) {
                    this.pst.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                this.poolConnection.checkIn(this.cnn);
            }
        }
    }
}

